/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs.protocol;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import jmri.jmrix.ipocs.protocol.packets.Packet;
import org.apache.commons.lang3.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    private byte length;
    private String objectName;
    private final List<Packet> packets = new ArrayList<Packet>();

    public byte getLength() {
        return this.length;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public List<Packet> getPackets() {
        return this.packets;
    }

    public static Message parse(ByteBuffer buffer, Integer contentSize) {
        Packet packet;
        byte last;
        int startPos = buffer.position();
        Message msg = new Message();
        msg.length = buffer.get();
        if (msg.length > contentSize) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while ((last = buffer.get()) != 0) {
            sb.append((char)last);
        }
        msg.objectName = sb.toString();
        log.debug("Message for {}", (Object)msg.objectName);
        while (buffer.position() - startPos < msg.length && (packet = Packet.parse(buffer)) != null) {
            msg.packets.add(packet);
        }
        return msg;
    }

    public ByteBuffer serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(1 + this.objectName.length() + 1);
        buffer.put(this.length);
        buffer.put(this.objectName.getBytes());
        buffer.put((byte)0);
        for (Packet packet : this.packets) {
            ByteBuffer serPacket = packet.serialize();
            ByteBuffer oldBuffer = buffer;
            oldBuffer.rewind();
            serPacket.rewind();
            buffer = ByteBuffer.allocate(buffer.capacity() + serPacket.capacity());
            buffer.put(oldBuffer);
            buffer.put(serPacket);
        }
        if (buffer.capacity() > 255) {
            throw new SerializationException("Serialized message is longer than protocol allows for.");
        }
        buffer.put(0, (byte)buffer.capacity());
        buffer.rewind();
        return buffer;
    }
}

