/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs.protocol.packets;

import java.nio.ByteBuffer;
import jmri.jmrix.ipocs.protocol.enums.RqAlarmState;
import jmri.jmrix.ipocs.protocol.packets.Packet;

public class AlarmPacket
extends Packet {
    public static final byte IDENT = 16;
    private short alarmCode;
    private byte alarmLevel;
    private RqAlarmState alarmState = null;
    private int parameter1;
    private int parameter2;

    @Override
    public byte getId() {
        return 16;
    }

    @Override
    protected void parseSpecific(ByteBuffer buffer) {
        this.alarmCode = buffer.getShort();
        this.alarmLevel = buffer.get();
        this.alarmState = RqAlarmState.valueOf(buffer.get());
        this.parameter1 = buffer.getInt();
        this.parameter2 = buffer.getInt();
    }

    @Override
    protected byte[] serializeSpecific() {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putShort(this.alarmCode);
        buffer.put(this.alarmLevel);
        buffer.put(this.alarmState.value);
        buffer.putInt(this.parameter1);
        buffer.putInt(this.parameter2);
        buffer.rewind();
        return buffer.array();
    }

    public short getAlarmCode() {
        return this.alarmCode;
    }

    public void setAlarmCode(short alarmCode) {
        this.alarmCode = alarmCode;
    }

    public byte getAlarmLevel() {
        return this.alarmLevel;
    }

    public void setAlarmLevel(byte alarmLevel) {
        this.alarmLevel = alarmLevel;
    }

    public RqAlarmState getAlarmState() {
        return this.alarmState;
    }

    public void setAlarmState(RqAlarmState alarmState) {
        this.alarmState = alarmState;
    }

    public int getParameter1() {
        return this.parameter1;
    }

    public void setParameter1(int parameter1) {
        this.parameter1 = parameter1;
    }

    public int getParameter2() {
        return this.parameter2;
    }

    public void setParameter2(int parameter2) {
        this.parameter2 = parameter2;
    }
}

