/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs.protocol.packets;

import java.nio.ByteBuffer;
import jmri.jmrix.ipocs.protocol.packets.Packet;

public class ConnectionRequestPacket
extends Packet {
    public static final byte IDENT = 1;
    private short protocolVersion;
    private String siteDataVersion = null;

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    protected byte[] serializeSpecific() {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this.siteDataVersion.length() + 1);
        buffer.putShort(this.protocolVersion);
        buffer.put(this.siteDataVersion.getBytes());
        buffer.put((byte)0);
        buffer.rewind();
        return buffer.array();
    }

    @Override
    protected void parseSpecific(ByteBuffer buffer) {
        byte last;
        this.protocolVersion = buffer.getShort();
        StringBuilder sb = new StringBuilder();
        while ((last = buffer.get()) != 0) {
            sb.append((char)last);
        }
        this.siteDataVersion = sb.toString();
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(short protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String getSiteDataVersion() {
        return this.siteDataVersion;
    }

    public void setSiteDataVersion(String siteDataVersion) {
        this.siteDataVersion = siteDataVersion;
    }
}

