/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jinput;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jmri.jmrix.jinput.UsbNode;
import jmri.util.HelpUtil;
import jmri.util.SystemType;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SING_SINGLETON_IMPLEMENTS_SERIALIZABLE"}, justification="DefaultTreeModel implements Serializable")
public final class TreeModel
extends DefaultTreeModel {
    Runner runner;
    DefaultMutableTreeNode dRoot;
    private static TreeModel instanceValue = null;
    Controller[] ca;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(TreeModel.class);

    private TreeModel() {
        super(new DefaultMutableTreeNode("Root"));
        this.dRoot = (DefaultMutableTreeNode)this.getRoot();
        boolean pass = this.loadSystem();
        if (!pass) {
            log.warn("loading of HID System failed");
        }
        this.runner = new Runner();
        this.runner.setName("jinput.TreeModel loader");
        this.runner.start();
    }

    private DefaultMutableTreeNode insertNode(DefaultMutableTreeNode pChild, DefaultMutableTreeNode pParent) {
        int index = this.getIndexOfChild(pParent, pChild);
        if (index >= 0) {
            return (DefaultMutableTreeNode)this.getChild(pParent, index);
        }
        index = pParent.getChildCount();
        try {
            this.insertNodeInto(pChild, pParent, index);
        }
        catch (IllegalArgumentException e) {
            log.error("insertNode({}, {})", new Object[]{pChild, pParent, e});
        }
        return pChild;
    }

    public static TreeModel instance() {
        if (instanceValue == null) {
            instanceValue = new TreeModel();
        }
        return instanceValue;
    }

    public void terminateThreads() throws InterruptedException {
        if (this.runner == null) {
            return;
        }
        this.runner.interrupt();
        this.runner.join();
    }

    public Controller[] controllers() {
        return Arrays.copyOf(this.ca, this.ca.length);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="This is due to a documented false-positive source")
    boolean loadSystem() {
        log.debug("start looking for controllers");
        try {
            this.ca = ControllerEnvironment.getDefaultEnvironment().getControllers();
            log.debug("Found {} controllers", (Object)this.ca.length);
        }
        catch (Throwable ex) {
            log.debug("Handling Throwable", ex);
            if (ex instanceof ClassNotFoundException) {
                switch (SystemType.getType()) {
                    case 4: {
                        log.error("Failed to find expected library", ex);
                    }
                }
                log.info("Did not find an implementation of a class needed for the interface; not proceeding");
                log.info("This is normal, because support isn't available for {}", (Object)SystemType.getOSName());
            } else {
                log.error("Encountered Throwable while getting controllers", ex);
            }
            this.ca = null;
            return false;
        }
        if (this.controllers().length == 0) {
            log.warn("No controllers found; tool is probably not working");
            HelpUtil.displayHelpRef("package.jmri.jmrix.jinput.treemodel.TreeFrame");
            return false;
        }
        block9: for (Controller controller : this.controllers()) {
            UsbNode controllerNode = null;
            UsbNode deviceNode = null;
            Component[] components = controller.getComponents();
            log.info("Controller {} has {} components", (Object)controller.getName(), (Object)components.length);
            for (Component component : components) {
                try {
                    if (controllerNode == null) {
                        String controllerName = controller.getName() + " [" + controller.getType().toString() + "]";
                        controllerNode = UsbNode.getNode(controllerName, controller, null);
                        controllerNode = (UsbNode)this.insertNode(controllerNode, this.dRoot);
                    }
                    String componentName = component.getName();
                    String componentIdentifierString = component.getIdentifier().toString();
                    if (componentName.equals("Unknown") || componentIdentifierString.equals("Unknown")) continue;
                    String deviceName = componentName + " [" + componentIdentifierString + "]";
                    deviceNode = UsbNode.getNode(deviceName, controller, component);
                    deviceNode = (UsbNode)this.insertNode(deviceNode, controllerNode);
                    deviceNode.setValue(0.0f);
                }
                catch (IllegalStateException e) {
                    continue block9;
                }
                catch (IllegalArgumentException e) {
                    log.error("insertNode({}, {}) Exception", new Object[]{deviceNode, controllerNode, e});
                }
                catch (Exception e) {
                    log.error("Exception", (Throwable)e);
                }
            }
        }
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    class Report
    implements Runnable {
        Controller controller;
        Component component;
        float value;

        Report(Controller controller, Component component, float value) {
            this.controller = controller;
            this.component = component;
            this.value = value;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            String cname = this.controller.getName() + " [" + this.controller.getType().toString() + "]";
            UsbNode cNode = UsbNode.getNode(cname, this.controller, null);
            try {
                cNode = (UsbNode)TreeModel.this.insertNode(cNode, TreeModel.this.dRoot);
            }
            catch (IllegalArgumentException e) {
                log.error("insertNode({}, {})", new Object[]{cNode, TreeModel.this.dRoot, e});
            }
            String dname = this.component.getName() + " [" + this.component.getIdentifier().toString() + "]";
            UsbNode dNode = UsbNode.getNode(dname, this.controller, this.component);
            try {
                dNode = (UsbNode)TreeModel.this.insertNode(dNode, cNode);
            }
            catch (IllegalArgumentException e) {
                log.error("insertNode({}, {})", new Object[]{dNode, cNode, e});
            }
            dNode.setValue(this.value);
            TreeModel.this.pcs.firePropertyChange("Value", dNode, Float.valueOf(this.value));
        }
    }

    class Runner
    extends Thread {
        Runner() {
        }

        @Override
        public void run() {
            while (true) {
                Controller[] controllers;
                if ((controllers = ControllerEnvironment.getDefaultEnvironment().getControllers()).length == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                for (int i = 0; i < controllers.length; ++i) {
                    controllers[i].poll();
                    EventQueue queue = controllers[i].getEventQueue();
                    Event event = new Event();
                    while (queue.getNextEvent(event)) {
                        Component comp = event.getComponent();
                        float value = event.getValue();
                        if (log.isDebugEnabled()) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append(controllers[i].getName());
                            buffer.append("] Component [");
                            buffer.append(comp.getName()).append("] changed to ");
                            if (comp.isAnalog()) {
                                buffer.append(value);
                            } else if (value == 1.0f) {
                                buffer.append("On");
                            } else {
                                buffer.append("Off");
                            }
                            log.debug("Name [ {}", (Object)buffer);
                        }
                        new Report(controllers[i], comp, value);
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

