/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jinput;

import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import jmri.InstanceManager;
import jmri.JmriException;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbNode
extends DefaultMutableTreeNode {
    String name;
    Controller controller;
    Component component;
    float val = -1.0f;
    String attachedSensor = null;
    String attachedMemory = null;
    private static final HashMap<Object, UsbNode> NODES = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(UsbNode.class);

    UsbNode(String name, Controller controller, Component component) {
        super(name);
        this.name = name;
        this.controller = controller;
        this.component = component;
    }

    public int hashCode() {
        if (this.controller == null) {
            return super.hashCode();
        }
        return this.controller.hashCode();
    }

    public Controller getController() {
        return this.controller;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean equals(Object a) {
        boolean result = false;
        if (a != null && a instanceof UsbNode) {
            UsbNode usbNode = (UsbNode)a;
            result = this.name.equals(usbNode.name) && this.controller == usbNode.controller && this.component == usbNode.component;
        }
        return result;
    }

    public void setValue(float val) {
        this.val = val;
        try {
            if (this.attachedSensor != null && !this.attachedSensor.equals("")) {
                InstanceManager.sensorManagerInstance().provideSensor(this.attachedSensor).setKnownState((double)val > 0.0 ? 2 : 4);
            }
        }
        catch (IllegalArgumentException | JmriException e1) {
            log.error("Can't set sensor", (Throwable)e1);
        }
        try {
            if (this.attachedMemory != null && !this.attachedMemory.equals("")) {
                InstanceManager.memoryManagerInstance().provideMemory(this.attachedMemory).setValue("" + val);
            }
        }
        catch (IllegalArgumentException e2) {
            log.error("Can't set memory", (Throwable)e2);
        }
    }

    public float getValue() {
        return this.val;
    }

    public void setAttachedSensor(String sensor) {
        this.attachedSensor = sensor;
    }

    public String getAttachedSensor() {
        return this.attachedSensor;
    }

    public void setAttachedMemory(String memory) {
        this.attachedMemory = memory;
    }

    public String getAttachedMemory() {
        return this.attachedMemory;
    }

    public String getName() {
        return this.name;
    }

    public static UsbNode getNode(String name, Controller controller, Component component) {
        Object key = component != null ? component : controller;
        UsbNode result = NODES.get(key);
        if (result == null) {
            result = new UsbNode(name, controller, component);
            NODES.put(key, result);
        }
        return result;
    }
}

