/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jinput.treecontrol;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import jmri.jmrix.jinput.TreeModel;
import jmri.jmrix.jinput.UsbNode;
import jmri.jmrix.jinput.treecontrol.Bundle;
import net.java.games.input.Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreePanel
extends JPanel {
    UsbNode currentNode = null;
    JLabel controllerName = new JLabel();
    JLabel controllerType = new JLabel();
    JLabel componentName = new JLabel();
    JLabel componentId = new JLabel();
    JLabel componentAnalog = new JLabel();
    JLabel componentRelative = new JLabel();
    JLabel componentValue = new JLabel();
    JCheckBox sensorBox = new JCheckBox(Bundle.getMessage("USBCopyJMRISensor") + "  ");
    JTextField sensorName = new JTextField(25);
    JCheckBox memoryBox = new JCheckBox(Bundle.getMessage("USBCopyJMRIMemory") + "  ");
    JTextField memoryName = new JTextField(25);
    JTree dTree = new JTree(TreeModel.instance());
    private static final Logger log = LoggerFactory.getLogger(TreePanel.class);

    public TreePanel() {
        super(true);
        this.setLayout(new BoxLayout(this, 1));
        JScrollPane treePanel = new JScrollPane(this.dTree);
        JPanel nodePanel = new JPanel();
        this.add(new JSplitPane(1, treePanel, nodePanel));
        this.dTree.setRootVisible(false);
        this.dTree.setShowsRootHandles(true);
        this.dTree.setScrollsOnExpand(true);
        this.dTree.setExpandsSelectedPaths(true);
        this.dTree.getSelectionModel().setSelectionMode(1);
        this.dTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!TreePanel.this.dTree.isSelectionEmpty() && TreePanel.this.dTree.getSelectionPath() != null) {
                    TreePanel.this.currentNode = TreePanel.this.getSelectedElement();
                    TreePanel.this.update();
                } else {
                    TreePanel.this.currentNode = null;
                    TreePanel.this.sensorBox.setSelected(false);
                    TreePanel.this.memoryBox.setSelected(false);
                    TreePanel.this.sensorName.setText("");
                    TreePanel.this.memoryName.setText("");
                }
            }
        });
        JPanel p2 = new JPanel();
        nodePanel.setLayout(new BorderLayout());
        nodePanel.add((Component)p2, "North");
        p2.setLayout(new BoxLayout(p2, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("USBController") + ": "));
        p.add(this.controllerName);
        p.add(Box.createHorizontalGlue());
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("USBType") + ": "));
        p.add(this.controllerType);
        p.add(Box.createHorizontalGlue());
        p2.add(p);
        p2.add((Component)new JSeparator(0), "North");
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("USBComponent") + ": "));
        p.add(this.componentName);
        p.add(Box.createHorizontalGlue());
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("USBIdentifier") + ": "));
        p.add(this.componentId);
        p.add(Box.createHorizontalGlue());
        p2.add(p);
        p2.add((Component)new JSeparator(0), "North");
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("USBAnalog") + ": "));
        p.add(this.componentAnalog);
        p.add(new JLabel("  " + Bundle.getMessage("USBRelative") + ": "));
        p.add(this.componentRelative);
        p.add(Box.createHorizontalGlue());
        p2.add(p);
        p2.add((Component)new JSeparator(0), "North");
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("USBValue") + ": "));
        p.add(this.componentValue);
        p.add(Box.createHorizontalGlue());
        p2.add(p);
        p2.add(new JSeparator(0));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.sensorBox);
        p.add(new JLabel(Bundle.getMessage("USBName") + ": "));
        p.add(this.sensorName);
        p.add(Box.createHorizontalGlue());
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.memoryBox);
        p.add(new JLabel(Bundle.getMessage("USBName") + ": "));
        p.add(this.memoryName);
        p.add(Box.createHorizontalGlue());
        p2.add(p);
        this.sensorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePanel.this.checkSensorBox();
            }
        });
        this.memoryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePanel.this.checkMemoryBox();
            }
        });
        this.sensorBox.setSelected(false);
        this.memoryBox.setSelected(false);
        this.sensorName.setEditable(true);
        this.memoryName.setEditable(true);
        TreeModel.instance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (TreePanel.this.currentNode != null && e.getOldValue() == TreePanel.this.currentNode) {
                    float value = ((Float)e.getNewValue()).floatValue();
                    if (TreePanel.this.currentNode.getComponent().isAnalog()) {
                        TreePanel.this.componentValue.setText("" + value);
                    } else {
                        TreePanel.this.componentValue.setText((double)value > 0.0 ? Bundle.getMessage("ButtonYes") : Bundle.getMessage("ButtonNo"));
                    }
                }
            }
        });
    }

    void checkSensorBox() {
        if (this.currentNode == null) {
            return;
        }
        if (this.sensorBox.isSelected()) {
            this.currentNode.setAttachedSensor(this.sensorName.getText());
            this.sensorName.setEditable(false);
        } else {
            this.currentNode.setAttachedSensor("");
            this.sensorName.setEditable(true);
        }
    }

    void checkMemoryBox() {
        if (this.currentNode == null) {
            return;
        }
        if (this.memoryBox.isSelected()) {
            this.currentNode.setAttachedMemory(this.memoryName.getText());
            this.memoryName.setEditable(false);
        } else {
            this.currentNode.setAttachedMemory("");
            this.memoryName.setEditable(true);
        }
    }

    void update() {
        Controller controller = this.currentNode.getController();
        if (controller != null) {
            this.controllerName.setText(controller.getName());
            this.controllerType.setText(controller.getType().toString());
        } else {
            this.controllerName.setText("");
            this.controllerType.setText("");
        }
        net.java.games.input.Component component = this.currentNode.getComponent();
        if (component != null) {
            this.componentName.setText(component.getName());
            this.componentId.setText(component.getIdentifier().toString());
            if (component.isAnalog()) {
                this.componentAnalog.setText(Bundle.getMessage("ButtonYes"));
                this.componentValue.setText("" + this.currentNode.getValue());
                this.componentRelative.setText(component.isRelative() ? Bundle.getMessage("ButtonYes") : Bundle.getMessage("ButtonNo"));
            } else {
                this.componentAnalog.setText(Bundle.getMessage("ButtonNo"));
                this.componentRelative.setText("");
                this.componentValue.setText((double)this.currentNode.getValue() > 0.0 ? Bundle.getMessage("ButtonYes") : Bundle.getMessage("ButtonNo"));
            }
            String attachedSensor = this.currentNode.getAttachedSensor();
            if (attachedSensor != null && !attachedSensor.isEmpty()) {
                this.sensorName.setText(attachedSensor);
                this.sensorName.setEditable(false);
                this.sensorBox.setSelected(true);
            } else {
                this.sensorName.setText("");
                this.sensorName.setEditable(true);
                this.sensorBox.setSelected(false);
            }
            String attachedMemory = this.currentNode.getAttachedMemory();
            if (attachedMemory != null && !attachedMemory.equals("")) {
                this.memoryName.setText(attachedMemory);
                this.memoryName.setEditable(false);
                this.memoryBox.setSelected(true);
            } else {
                this.memoryName.setText("");
                this.memoryName.setEditable(true);
                this.memoryBox.setSelected(false);
            }
        } else {
            this.componentName.setText("");
            this.componentId.setText("");
            this.componentAnalog.setText(Bundle.getMessage("ButtonNo"));
            this.componentRelative.setText(Bundle.getMessage("ButtonNo"));
            this.componentValue.setText("");
            this.sensorName.setText("");
            this.sensorName.setEditable(true);
            this.sensorBox.setSelected(false);
            this.memoryName.setText("");
            this.memoryName.setEditable(true);
            this.memoryBox.setSelected(false);
        }
    }

    public UsbNode getSelectedElement() {
        if (!this.dTree.isSelectionEmpty() && this.dTree.getSelectionPath() != null) {
            log.debug("getSelectedIcon with {}", (Object)this.dTree.getSelectionPath().toString());
            TreePath path = this.dTree.getSelectionPath();
            int level = path.getPathCount();
            return (UsbNode)path.getPathComponent(level - 1);
        }
        return null;
    }
}

