/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jmriclient;

import jmri.implementation.AbstractLight;
import jmri.jmrix.jmriclient.JMRIClientListener;
import jmri.jmrix.jmriclient.JMRIClientMessage;
import jmri.jmrix.jmriclient.JMRIClientReply;
import jmri.jmrix.jmriclient.JMRIClientSystemConnectionMemo;
import jmri.jmrix.jmriclient.JMRIClientTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMRIClientLight
extends AbstractLight
implements JMRIClientListener {
    private int _number;
    private JMRIClientTrafficController tc = null;
    private String transmitName = null;
    private static final Logger log = LoggerFactory.getLogger(JMRIClientLight.class);

    public JMRIClientLight(int number, JMRIClientSystemConnectionMemo memo) {
        super(memo.getSystemPrefix() + "l" + number);
        this._number = number;
        this.transmitName = memo.getTransmitPrefix() + "L" + number;
        this.tc = memo.getJMRIClientTrafficController();
        this.tc.addJMRIClientListener(this);
        this.requestUpdateFromLayout();
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    public void requestUpdateFromLayout() {
        String text = "LIGHT " + this.transmitName + "\n";
        this.tc.sendJMRIClientMessage(new JMRIClientMessage(text), this);
    }

    @Override
    public synchronized void doNewState(int oldState, int s) {
        if (oldState == s) {
            return;
        }
        if ((s & 2) != 0) {
            if ((s & 4) != 0) {
                log.error("Cannot command both ON and OFF {}", (Object)s);
                return;
            }
            this.sendMessage(true);
        } else {
            this.sendMessage(false);
        }
        this.notifyStateChange(oldState, s);
    }

    protected void sendMessage(boolean on) {
        String text = on ? "LIGHT " + this.transmitName + " ON\n" : "LIGHT " + this.transmitName + " OFF\n";
        this.tc.sendJMRIClientMessage(new JMRIClientMessage(text), this);
    }

    @Override
    public synchronized void reply(JMRIClientReply m) {
        String message = m.toString();
        if (!message.contains(this.transmitName + " ")) {
            return;
        }
        if (m.toString().contains("OFF")) {
            this.notifyStateChange(this.mState, 4);
        } else if (m.toString().contains("ON")) {
            this.notifyStateChange(this.mState, 2);
        } else {
            this.notifyStateChange(this.mState, 1);
        }
    }

    @Override
    public void message(JMRIClientMessage m) {
    }
}

