/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jmriclient;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.jmriclient.JMRIClientLight;
import jmri.jmrix.jmriclient.JMRIClientSystemConnectionMemo;
import jmri.managers.AbstractLightManager;

public class JMRIClientLightManager
extends AbstractLightManager {
    public JMRIClientLightManager(JMRIClientSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public JMRIClientSystemConnectionMemo getMemo() {
        return (JMRIClientSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr = Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
        JMRIClientLight t = new JMRIClientLight(addr, this.getMemo());
        t.setUserName(userName);
        return t;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return systemName.startsWith(this.getSystemNamePrefix()) && Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length())) > 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return super.validateIntegerSystemNameFormat(name, 0, Integer.MAX_VALUE, locale);
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return true;
    }
}

