/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jmriclient;

import jmri.implementation.AbstractReporter;
import jmri.jmrix.jmriclient.JMRIClientListener;
import jmri.jmrix.jmriclient.JMRIClientMessage;
import jmri.jmrix.jmriclient.JMRIClientReply;
import jmri.jmrix.jmriclient.JMRIClientSystemConnectionMemo;
import jmri.jmrix.jmriclient.JMRIClientTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMRIClientReporter
extends AbstractReporter
implements JMRIClientListener {
    private int _number;
    private JMRIClientTrafficController tc = null;
    private String transmitName = null;
    private int state = 1;
    private static final Logger log = LoggerFactory.getLogger(JMRIClientReporter.class);

    public JMRIClientReporter(int number, JMRIClientSystemConnectionMemo memo) {
        super(memo.getSystemPrefix() + "R" + number);
        this.transmitName = memo.getTransmitPrefix() + "R" + number;
        this._number = number;
        this.tc = memo.getJMRIClientTrafficController();
        this.tc.addJMRIClientListener(this);
        this.requestUpdateFromLayout();
    }

    public int getNumber() {
        return this._number;
    }

    public void requestUpdateFromLayout() {
        String text = "REPORTER " + this.transmitName + "\n";
        this.tc.sendJMRIClientMessage(new JMRIClientMessage(text), this);
    }

    @Override
    public void reply(JMRIClientReply m) {
        String message = m.toString();
        log.debug("Message Received: {}", (Object)m);
        log.debug("length {}", (Object)message.length());
        if (!(message.contains(this.transmitName + " ") || message.contains(this.transmitName + "\n") || message.contains(this.transmitName + "\r"))) {
            return;
        }
        String text = "REPORTER " + this.transmitName + "\n";
        if (!message.equals(text)) {
            String report = message.substring(text.length());
            log.debug("setting report to {}", (Object)report);
            this.setReport(report);
        } else {
            log.debug("setting report to null");
            this.setReport(null);
        }
    }

    @Override
    public void message(JMRIClientMessage m) {
    }

    @Override
    public void setState(int s) {
        this.state = s;
    }

    @Override
    public int getState() {
        return this.state;
    }
}

