/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jmriclient;

import jmri.JmriException;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.jmriclient.JMRIClientListener;
import jmri.jmrix.jmriclient.JMRIClientMessage;
import jmri.jmrix.jmriclient.JMRIClientReply;
import jmri.jmrix.jmriclient.JMRIClientSystemConnectionMemo;
import jmri.jmrix.jmriclient.JMRIClientTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMRIClientSensor
extends AbstractSensor
implements JMRIClientListener {
    private int _number;
    private JMRIClientTrafficController tc = null;
    private String transmitName = null;
    private static final Logger log = LoggerFactory.getLogger(JMRIClientSensor.class);

    public JMRIClientSensor(int number, JMRIClientSystemConnectionMemo memo) {
        super(memo.getSystemPrefix() + "S" + number);
        this._number = number;
        this.transmitName = memo.getTransmitPrefix() + "S" + number;
        this.tc = memo.getJMRIClientTrafficController();
        this.tc.addJMRIClientListener(this);
        this.requestUpdateFromLayout();
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    public void setKnownState(int newState) throws JmriException {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both ACTIVE and INACTIVE {}", (Object)newState);
                return;
            }
            this.sendMessage(true ^ this.getInverted());
        } else {
            this.sendMessage(false ^ this.getInverted());
        }
        if (this._knownState != newState) {
            int oldState = this._knownState;
            this._knownState = newState;
            this.firePropertyChange("KnownState", oldState, this._knownState);
        }
    }

    @Override
    public void requestUpdateFromLayout() {
        String text = "SENSOR " + this.transmitName + "\n";
        this.tc.sendJMRIClientMessage(new JMRIClientMessage(text), this);
    }

    protected void sendMessage(boolean active) {
        String text = active ? "SENSOR " + this.transmitName + " ACTIVE\n" : "SENSOR " + this.transmitName + " INACTIVE\n";
        this.tc.sendJMRIClientMessage(new JMRIClientMessage(text), this);
    }

    @Override
    public void reply(JMRIClientReply m) {
        String message = m.toString();
        log.debug("Message Received: {}", (Object)m);
        if (!message.contains(this.transmitName + " ")) {
            return;
        }
        if (m.toString().contains("INACTIVE")) {
            this.setOwnState(!this.getInverted() ? 4 : 2);
        } else if (m.toString().contains("ACTIVE")) {
            this.setOwnState(!this.getInverted() ? 2 : 4);
        } else {
            this.setOwnState(1);
        }
    }

    @Override
    public void message(JMRIClientMessage m) {
    }
}

