/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jmriclient;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.jmriclient.JMRIClientSensor;
import jmri.jmrix.jmriclient.JMRIClientSystemConnectionMemo;
import jmri.managers.AbstractSensorManager;

public class JMRIClientSensorManager
extends AbstractSensorManager {
    public JMRIClientSensorManager(JMRIClientSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public JMRIClientSystemConnectionMemo getMemo() {
        return (JMRIClientSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Can't convert " + systemName.substring(this.getSystemPrefix().length() + 1) + " to JMRIClient sensor address");
        }
        JMRIClientSensor t = new JMRIClientSensor(addr, this.getMemo());
        t.setUserName(userName);
        return t;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        return prefix + this.typeLetter() + curAddress;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateSystemNameFormatOnlyNumeric(name, locale);
    }
}

