/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jmriclient;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrix.jmriclient.JMRIClientSystemConnectionMemo;
import jmri.jmrix.jmriclient.JMRIClientTurnout;
import jmri.managers.AbstractTurnoutManager;

public class JMRIClientTurnoutManager
extends AbstractTurnoutManager {
    public JMRIClientTurnoutManager(JMRIClientSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public JMRIClientSystemConnectionMemo getMemo() {
        return (JMRIClientSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to convert systemName '" + systemName + "' to a Turnout.");
        }
        JMRIClientTurnout t = new JMRIClientTurnout(addr, this.getMemo());
        t.setUserName(userName);
        return t;
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        return prefix + this.typeLetter() + curAddress;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateSystemNameFormatOnlyNumeric(name, locale);
    }
}

