/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jserialcomm;

import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.SerialPort;
import jmri.jmrix.SerialPortDataListener;
import jmri.jmrix.jserialcomm.JSerialPortEvent;
import jmri.util.LoggingUtil;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSerialPort
implements SerialPort {
    private final com.fazecast.jSerialComm.SerialPort serialPort;
    private static final Logger log = LoggerFactory.getLogger(JSerialPort.class);

    private JSerialPort(com.fazecast.jSerialComm.SerialPort serialPort) {
        this.serialPort = serialPort;
    }

    @Override
    public void addDataListener(final SerialPortDataListener listener) {
        this.serialPort.addDataListener(new com.fazecast.jSerialComm.SerialPortDataListener(){

            public int getListeningEvents() {
                return listener.getListeningEvents();
            }

            public void serialEvent(SerialPortEvent event) {
                listener.serialEvent(new JSerialPortEvent(event));
            }
        });
    }

    @Override
    public InputStream getInputStream() {
        return this.serialPort.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.serialPort.getOutputStream();
    }

    @Override
    public void setRTS() {
        this.serialPort.setRTS();
    }

    @Override
    public void clearRTS() {
        this.serialPort.clearRTS();
    }

    @Override
    public void setBaudRate(int baudrate) {
        this.serialPort.setBaudRate(baudrate);
    }

    @Override
    public int getBaudRate() {
        return this.serialPort.getBaudRate();
    }

    @Override
    public void setNumDataBits(int bits) {
        this.serialPort.setNumDataBits(bits);
    }

    @Override
    public final int getNumDataBits() {
        return this.serialPort.getNumDataBits();
    }

    @Override
    public void setNumStopBits(int bits) {
        this.serialPort.setNumStopBits(bits);
    }

    @Override
    public final int getNumStopBits() {
        return this.serialPort.getNumStopBits();
    }

    @Override
    public void setParity(SerialPort.Parity parity) {
        this.serialPort.setParity(parity.getValue());
    }

    @Override
    public SerialPort.Parity getParity() {
        return SerialPort.Parity.getParity(this.serialPort.getParity());
    }

    @Override
    public void setDTR() {
        this.serialPort.setDTR();
    }

    @Override
    public void clearDTR() {
        this.serialPort.clearDTR();
    }

    @Override
    public boolean getDTR() {
        return this.serialPort.getDTR();
    }

    @Override
    public boolean getRTS() {
        return this.serialPort.getRTS();
    }

    @Override
    public boolean getDSR() {
        return this.serialPort.getDSR();
    }

    @Override
    public boolean getCTS() {
        return this.serialPort.getCTS();
    }

    @Override
    public boolean getDCD() {
        return this.serialPort.getDCD();
    }

    @Override
    public boolean getRI() {
        return this.serialPort.getRI();
    }

    @Override
    public final void setFlowControl(AbstractSerialPortController.FlowControl flow) {
        boolean result = true;
        if (null == flow) {
            log.error("Invalid null FlowControl enum member");
        } else {
            switch (flow) {
                case RTSCTS: {
                    result = this.serialPort.setFlowControl(17);
                    break;
                }
                case XONXOFF: {
                    result = this.serialPort.setFlowControl(0x110000);
                    break;
                }
                case NONE: {
                    result = this.serialPort.setFlowControl(0);
                    break;
                }
                default: {
                    log.error("Invalid FlowControl enum member: {}", (Object)flow);
                }
            }
        }
        if (!result) {
            log.error("Port did not accept flow control setting {}", (Object)flow);
        }
    }

    @Override
    public void setBreak() {
        this.serialPort.setBreak();
    }

    @Override
    public void clearBreak() {
        this.serialPort.clearBreak();
    }

    @Override
    public final int getFlowControlSettings() {
        return this.serialPort.getFlowControlSettings();
    }

    @Override
    public final boolean setComPortTimeouts(int newTimeoutMode, int newReadTimeout, int newWriteTimeout) {
        return this.serialPort.setComPortTimeouts(newTimeoutMode, newReadTimeout, newWriteTimeout);
    }

    @Override
    public void closePort() {
        this.serialPort.closePort();
    }

    @Override
    public String getDescriptivePortName() {
        return this.serialPort.getDescriptivePortName();
    }

    @Override
    public String toString() {
        return this.serialPort.toString();
    }

    public static JSerialPort activatePort(String systemPrefix, String inputPortName, Logger log, int stop_bits, SerialPort.Parity parity) {
        com.fazecast.jSerialComm.SerialPort serialPort;
        int stop_bits_code;
        String portName;
        String envVar = "JMRI_SERIALPORT";
        String fromEnv = System.getenv("JMRI_SERIALPORT");
        log.debug("Environment {} {} was {}", new Object[]{"JMRI_SERIALPORT", fromEnv, inputPortName});
        String fromProp = System.getProperty("JMRI_SERIALPORT");
        log.debug("Property {} {} was {}", new Object[]{"JMRI_SERIALPORT", fromProp, inputPortName});
        if (fromEnv != null) {
            LoggingUtil.infoOnce(log, "{} set, using environment \"{}\" as Port Name", "JMRI_SERIALPORT", fromEnv);
            portName = fromEnv;
        } else if (fromProp != null) {
            LoggingUtil.infoOnce(log, "{} set, using property \"{}\" as Port Name", "JMRI_SERIALPORT", fromProp);
            portName = fromProp;
        } else {
            portName = inputPortName;
        }
        switch (stop_bits) {
            case 1: {
                stop_bits_code = 1;
                break;
            }
            case 2: {
                stop_bits_code = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect stop_bits argument: " + stop_bits);
            }
        }
        try {
            serialPort = com.fazecast.jSerialComm.SerialPort.getCommPort((String)portName);
            serialPort.openPort();
            serialPort.setComPortTimeouts(16, 0, 0);
            serialPort.setNumDataBits(8);
            serialPort.setNumStopBits(stop_bits_code);
            serialPort.setParity(parity.getValue());
            AbstractPortController.purgeStream(serialPort.getInputStream());
        }
        catch (SerialPortInvalidPortException | IOException ex) {
            AbstractSerialPortController.handlePortNotFound(systemPrefix, portName, log, (Exception)ex);
            return null;
        }
        return new JSerialPort(serialPort);
    }

    private static String getSymlinkTarget(File symlink) {
        try {
            return symlink.toPath().toRealPath(new LinkOption[0]).toFile().getName();
        }
        catch (IOException e) {
            return null;
        }
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static Vector<String> getActualPortNames() {
        File[] files;
        com.fazecast.jSerialComm.SerialPort[] portIDs;
        Vector<String> portNameVector = new Vector<String>();
        for (com.fazecast.jSerialComm.SerialPort portID : portIDs = com.fazecast.jSerialComm.SerialPort.getCommPorts()) {
            portNameVector.addElement(portID.getSystemPortName());
        }
        if ((SystemType.isLinux() || SystemType.isMacOSX()) && (files = new File("/dev").listFiles()) != null) {
            Set symlinkPorts = Stream.of(files).filter(file -> !file.isDirectory() && portNameVector.contains(JSerialPort.getSymlinkTarget(file)) && !portNameVector.contains(file.getName())).map(File::getName).collect(Collectors.toSet());
            portNameVector.addAll(symlinkPorts);
            log.info("Adding symlink port {}", symlinkPorts);
            String portnamePattern = System.getProperty("purejavacomm.portnamepattern");
            if (portnamePattern != null) {
                Pattern pattern = Pattern.compile(portnamePattern);
                Set ports = Stream.of(files).filter(file -> !file.isDirectory() && pattern.matcher(file.getName()).matches() && !portNameVector.contains(file.getName())).map(File::getName).collect(Collectors.toSet());
                portNameVector.addAll(ports);
                log.info("Adding user-specified ports {} matching pattern {}", ports, (Object)portnamePattern);
            }
        }
        return portNameVector;
    }
}

