/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.CommandStation;
import jmri.jmrix.lenz.Bundle;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LenzCommandStation
implements CommandStation {
    private int cmdStationType = -1;
    private float cmdStationSoftwareVersion = -1.0f;
    private int cmdStationSoftwareVersionBCD = -1;
    private XNetTrafficController _tc = null;
    XNetSystemConnectionMemo adaptermemo;
    private static final Logger log = LoggerFactory.getLogger(LenzCommandStation.class);

    public int getCommandStationType() {
        return this.cmdStationType;
    }

    public void setCommandStationType(int t) {
        this.cmdStationType = t;
    }

    public void setCommandStationType(XNetReply l) {
        if (l.getElement(0) == 99 && l.getElement(1) == 33) {
            this.cmdStationType = l.getElement(3);
        }
    }

    public float getCommandStationSoftwareVersion() {
        return this.cmdStationSoftwareVersion;
    }

    public float getCommandStationSoftwareVersionBCD() {
        return this.cmdStationSoftwareVersionBCD;
    }

    public void setCommandStationSoftwareVersion(float v) {
        this.cmdStationSoftwareVersion = v;
    }

    public void setCommandStationSoftwareVersion(XNetReply l) {
        if (l.getElement(0) == 99 && l.getElement(1) == 33) {
            try {
                this.cmdStationSoftwareVersion = l.getElementBCD(2).floatValue() / 10.0f;
            }
            catch (NumberFormatException nfe) {
                this.cmdStationSoftwareVersion = (float)((l.getElement(2) & 0xF0) >> 4) + (float)(l.getElement(2) & 0xF) / 100.0f;
            }
            this.cmdStationSoftwareVersionBCD = l.getElement(2);
        }
    }

    public String getVersionString() {
        return Bundle.getMessage("CSVersionString", this.getCommandStationType(), Float.valueOf(this.getCommandStationSoftwareVersionBCD()));
    }

    public boolean isOpsModePossible() {
        return this.cmdStationType != 1 && this.cmdStationType != 2;
    }

    public static int getDCCAddressLow(int address) {
        if (address < 100) {
            return address;
        }
        int temp = address + 49152;
        return temp &= 0xFF;
    }

    public static int getDCCAddressHigh(int address) {
        if (address < 100) {
            return 0;
        }
        int temp = address + 49152;
        temp &= 0xFF00;
        return temp /= 256;
    }

    public static int calcLocoAddress(int AH, int AL2) {
        if (AH == 0) {
            return AL2;
        }
        if ((AH & 0xC0) == 128) {
            if ((AL2 & 0x80) == 128) {
                int part1 = AH & 0x3F;
                int part2 = ~AL2;
                part2 &= 0x70;
                int address = (part2 <<= 2) | part1;
                return address;
            }
            int part1 = AH & 0x3F;
            int part2 = ~AL2;
            part2 &= 0x70;
            int part3 = AL2;
            part3 &= 6;
            int address = (part2 <<= 4) | (part1 <<= 2) | (part3 >>= 1);
            return ++address;
        }
        int address = AH * 256 & 0xFF00;
        address += AL2 & 0xFF;
        return address -= 49152;
    }

    @Override
    public boolean sendPacket(byte[] packet, int repeats) {
        if (this._tc == null) {
            log.error("Send Packet Called without setting traffic controller");
            return false;
        }
        XNetMessage msg = XNetMessage.getNMRAXNetMsg(packet);
        for (int i = 0; i < repeats; ++i) {
            this._tc.sendXNetMessage(msg, null);
        }
        return true;
    }

    public void setTrafficController(XNetTrafficController tc) {
        this._tc = tc;
    }

    public void setSystemConnectionMemo(XNetSystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    @Override
    public String getUserName() {
        if (this.adaptermemo == null) {
            return Bundle.getMessage("MenuXpressNet");
        }
        return this.adaptermemo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        if (this.adaptermemo == null) {
            return "X";
        }
        return this.adaptermemo.getSystemPrefix();
    }
}

