/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Light;
import jmri.Manager;
import jmri.Sensor;
import jmri.Turnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetAddress {
    static final int MINSENSORADDRESS = 1;
    static final int MAXSENSORADDRESS = 1024;
    private static final Logger log = LoggerFactory.getLogger(XNetAddress.class);

    public static int getBitFromSystemName(String systemName, String prefix) {
        int num;
        if (!systemName.startsWith(prefix)) {
            log.error("invalid character in header field of XpressNet system name: {} wants prefix {}", (Object)systemName, (Object)prefix);
            return -1;
        }
        try {
            String curAddress = systemName.substring(prefix.length() + 1);
            if ((systemName.charAt(prefix.length()) == 'S' || systemName.charAt(prefix.length()) == 's') && curAddress.contains(":")) {
                int seperator = curAddress.indexOf(":");
                int encoderAddress = Integer.parseInt(curAddress.substring(0, seperator));
                int input = Integer.parseInt(curAddress.substring(seperator + 1));
                num = (encoderAddress - 1) * 8 + input;
            } else {
                num = Integer.parseInt(curAddress);
            }
        }
        catch (NumberFormatException e) {
            log.warn("invalid character in number field of system name: {}", (Object)systemName);
            return -1;
        }
        if (num >= 1 && num <= 1024) {
            return num;
        }
        log.warn("XpressNet hardware address out of range in system name {}", (Object)systemName);
        return -1;
    }

    public static Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type, String prefix) {
        if (!systemName.startsWith(prefix + type)) {
            log.error("invalid character in header field of system name: {} wants prefix {} type {}", new Object[]{systemName, prefix, Character.valueOf(type)});
            return Manager.NameValidity.INVALID;
        }
        if (XNetAddress.getBitFromSystemName(systemName, prefix) > 0) {
            return Manager.NameValidity.VALID;
        }
        return Manager.NameValidity.INVALID;
    }

    public static String getUserNameFromSystemName(String systemName, String prefix) {
        if (systemName.length() < prefix.length() + 2 || !systemName.startsWith(prefix)) {
            return "";
        }
        if (systemName.charAt(prefix.length() + 1) == 'S') {
            Sensor s = InstanceManager.sensorManagerInstance().getBySystemName(systemName);
            if (s != null) {
                return s.getUserName();
            }
            return "";
        }
        if (systemName.charAt(prefix.length() + 1) == 'T') {
            Turnout t = InstanceManager.turnoutManagerInstance().getBySystemName(systemName);
            if (t != null) {
                return t.getUserName();
            }
            return "";
        }
        if (systemName.charAt(prefix.length() + 1) == 'L') {
            Light lgt = InstanceManager.lightManagerInstance().getBySystemName(systemName);
            if (lgt != null) {
                return lgt.getUserName();
            }
            return "";
        }
        return "";
    }
}

