/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.DccLocoAddress;
import jmri.SpeedStepMode;
import jmri.implementation.DccConsist;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetConsist
extends DccConsist
implements XNetListener {
    private static final int IDLESTATE = 0;
    private static final int ADDREQUESTSENTSTATE = 1;
    private static final int REMOVEREQUESTSENTSTATE = 2;
    private static final String CONSIST_TYPE_NOT_SUPPORTED = "Consist Type Not Supported";
    private int _state = 0;
    private DccLocoAddress _locoAddress = null;
    private boolean _directionNormal = false;
    protected XNetTrafficController tc;
    final XNetSystemConnectionMemo systemMemo;
    private static final Logger log = LoggerFactory.getLogger(XNetConsist.class);

    public XNetConsist(int address, XNetTrafficController controller, XNetSystemConnectionMemo systemMemo) {
        super(address);
        this.tc = controller;
        this.systemMemo = systemMemo;
        this.tc.addXNetListener(33, this);
    }

    public XNetConsist(DccLocoAddress address, XNetTrafficController controller, XNetSystemConnectionMemo systemMemo) {
        super(address);
        this.tc = controller;
        this.systemMemo = systemMemo;
        this.tc.addXNetListener(33, this);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.tc.removeXNetListener(33, this);
    }

    @Override
    public void setConsistType(int consistType) {
        switch (consistType) {
            case 0: 
            case 1: {
                this.consistType = consistType;
                break;
            }
            default: {
                log.error(CONSIST_TYPE_NOT_SUPPORTED);
                this.notifyConsistListeners(new DccLocoAddress(0, false), 1);
            }
        }
    }

    @Override
    public boolean isAddressAllowed(DccLocoAddress address) {
        return address.getNumber() != 0;
    }

    @Override
    public int sizeLimit() {
        switch (this.consistType) {
            case 0: {
                return -1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public boolean contains(DccLocoAddress address) {
        if (this.consistType == 0 || this.consistType == 1) {
            return this.consistList.contains(address);
        }
        log.error(CONSIST_TYPE_NOT_SUPPORTED);
        this.notifyConsistListeners(address, 1);
        return false;
    }

    @Override
    public boolean getLocoDirection(DccLocoAddress address) {
        if (this.consistType == 0 || this.consistType == 1) {
            return (Boolean)this.consistDir.get(address);
        }
        log.error(CONSIST_TYPE_NOT_SUPPORTED);
        this.notifyConsistListeners(address, 1);
        return false;
    }

    private synchronized void addToConsistList(DccLocoAddress locoAddress, boolean directionNormal) {
        if (!this.consistList.contains(locoAddress)) {
            this.consistList.add(locoAddress);
        }
        this.consistDir.put(locoAddress, directionNormal);
        if (this.consistType == 1 && this.consistList.size() == 2) {
            this.notifyConsistListeners(locoAddress, 10);
        } else {
            this.notifyConsistListeners(locoAddress, 2);
        }
    }

    private synchronized void removeFromConsistList(DccLocoAddress locoAddress) {
        if (this.consistList.contains(locoAddress)) {
            this.consistDir.remove(locoAddress);
            this.consistList.remove(locoAddress);
        }
        this.notifyConsistListeners(locoAddress, 2);
    }

    @Override
    public synchronized void add(DccLocoAddress locoAddress, boolean directionNormal) {
        switch (this.consistType) {
            case 0: {
                this.addToAdvancedConsist(locoAddress, directionNormal);
                this._locoAddress = locoAddress;
                this._directionNormal = directionNormal;
                break;
            }
            case 1: {
                if (this.consistList.size() < 2) {
                    if (this.consistList.size() == 1 && !this.consistList.contains(locoAddress)) {
                        this.addToCSConsist(locoAddress, directionNormal);
                        this._locoAddress = locoAddress;
                        this._directionNormal = directionNormal;
                        break;
                    }
                    if (this.consistList.isEmpty()) {
                        this.addToConsistList(locoAddress, directionNormal);
                        break;
                    }
                    this.notifyConsistListeners(locoAddress, 36);
                    break;
                }
                if (this.consistList.size() == 2 && this.consistList.contains(locoAddress)) {
                    this.addToCSConsist(locoAddress, directionNormal);
                    this._locoAddress = locoAddress;
                    this._directionNormal = directionNormal;
                    break;
                }
                this.notifyConsistListeners(locoAddress, 12);
                break;
            }
            default: {
                log.error(CONSIST_TYPE_NOT_SUPPORTED);
                this.notifyConsistListeners(locoAddress, 1);
            }
        }
    }

    @Override
    public synchronized void restore(DccLocoAddress locoAddress, boolean directionNormal) {
        switch (this.consistType) {
            case 0: 
            case 1: {
                this.addToConsistList(locoAddress, directionNormal);
                break;
            }
            default: {
                log.error(CONSIST_TYPE_NOT_SUPPORTED);
                this.notifyConsistListeners(locoAddress, 1);
            }
        }
    }

    @Override
    public synchronized void remove(DccLocoAddress locoAddress) {
        log.debug("Consist {}: remove called for address {}", (Object)this.consistAddress, (Object)locoAddress);
        switch (this.consistType) {
            case 0: {
                this._locoAddress = locoAddress;
                this.removeFromAdvancedConsist(locoAddress);
                break;
            }
            case 1: {
                if (this.consistList.size() == 2 && this._state != 2) {
                    this._locoAddress = locoAddress;
                    this.removeFromCSConsist(locoAddress);
                    break;
                }
                if (this._state == 2 && this._locoAddress == locoAddress) break;
                this.removeFromConsistList(locoAddress);
                break;
            }
            default: {
                log.error(CONSIST_TYPE_NOT_SUPPORTED);
                this.notifyConsistListeners(locoAddress, 1);
            }
        }
    }

    @Override
    protected synchronized void addToAdvancedConsist(DccLocoAddress locoAddress, boolean directionNormal) {
        log.debug("Adding locomotive {} to consist {}", (Object)locoAddress.getNumber(), (Object)this.consistAddress.getNumber());
        if (this.contains(locoAddress)) {
            this.removeFromAdvancedConsist(locoAddress);
        }
        this.sendDirection(locoAddress, directionNormal);
        XNetMessage msg = XNetMessage.getAddLocoToConsistMsg(this.consistAddress.getNumber(), locoAddress.getNumber(), directionNormal);
        this.tc.sendXNetMessage(msg, this);
        this._state = 1;
    }

    @Override
    protected synchronized void removeFromAdvancedConsist(DccLocoAddress locoAddress) {
        this.sendDirection(locoAddress, this.getLocoDirection(locoAddress));
        XNetMessage msg = XNetMessage.getRemoveLocoFromConsistMsg(this.consistAddress.getNumber(), locoAddress.getNumber());
        this.tc.sendXNetMessage(msg, this);
        this._state = 2;
    }

    private synchronized void addToCSConsist(DccLocoAddress locoAddress, boolean directionNormal) {
        if (this.consistAddress.equals(locoAddress)) {
            log.error("Attempted to add {} to consist {}", (Object)locoAddress, (Object)this.consistAddress);
            this._state = 0;
            this.notifyConsistListeners(this._locoAddress, 36);
            return;
        }
        if (this.consistList.size() == 2 && this.consistList.contains(locoAddress)) {
            XNetMessage msg = XNetMessage.getDisolveDoubleHeaderMsg(((DccLocoAddress)this.consistList.get(0)).getNumber());
            this.tc.sendXNetMessage(msg, this);
        }
        DccLocoAddress address = (DccLocoAddress)this.consistList.get(0);
        Boolean direction = (Boolean)this.consistDir.get(address);
        this.sendDirection(address, direction);
        this.sendDirection(locoAddress, directionNormal);
        XNetMessage msg = XNetMessage.getBuildDoubleHeaderMsg(address.getNumber(), locoAddress.getNumber());
        this.tc.sendXNetMessage(msg, this);
        this._state = 1;
    }

    public synchronized void removeFromCSConsist(DccLocoAddress locoAddress) {
        XNetMessage msg = XNetMessage.getDisolveDoubleHeaderMsg(((DccLocoAddress)this.consistList.get(0)).getNumber());
        this.tc.sendXNetMessage(msg, this);
        this._state = 2;
    }

    @Override
    public synchronized void message(XNetReply l) {
        if (this._state != 0) {
            if (l.isOkMessage()) {
                if (this._state == 1) {
                    this.addToConsistList(this._locoAddress, this._directionNormal);
                    if (this.consistType == 0) {
                        this.setRosterEntryCVValue(this._locoAddress);
                    }
                } else if (this._state == 2) {
                    if (this.consistType == 0) {
                        this.resetRosterEntryCVValue(this._locoAddress);
                    }
                    this.removeFromConsistList(this._locoAddress);
                }
                this._state = 0;
            } else if (l.getElement(0) == 225) {
                String text;
                switch (l.getElement(1)) {
                    case 129: {
                        text = "Selected Locomotive has not been operated by this XpressNet device or address 0 selected";
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 20);
                        break;
                    }
                    case 130: {
                        text = "Selected Locomotive is being operated by another XpressNet device";
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 20);
                        break;
                    }
                    case 131: {
                        text = "Selected Locomotive already in MU or DH";
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 36);
                        break;
                    }
                    case 132: {
                        text = "Unit selected for MU or DH has speed setting other than 0";
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 132);
                        break;
                    }
                    case 133: {
                        text = "Locomotive not in a MU";
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 68);
                        break;
                    }
                    case 134: {
                        text = "Locomotive address not a multi-unit base address";
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 260);
                        break;
                    }
                    case 135: {
                        text = "It is not possible to delete the locomotive";
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 516);
                        break;
                    }
                    case 136: {
                        text = "The Command Station Stack is Full";
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 1028);
                        break;
                    }
                    default: {
                        text = "Unknown";
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 4);
                    }
                }
                log.error("XpressNet MU+DH error: {}", (Object)text);
            }
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message{}", (Object)msg);
    }

    private void sendDirection(DccLocoAddress address, boolean isForward) {
        XNetMessage msg = XNetMessage.getSpeedAndDirectionMsg(address.getNumber(), SpeedStepMode.NMRA_DCC_28, 0.0f, isForward);
        this.tc.sendXNetMessage(msg, this);
    }
}

