/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import javax.swing.Timer;
import jmri.GlobalProgrammerManager;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetProgrammer;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;

public class XNetHeartBeat
implements XNetListener {
    private Timer keepAliveTimer;
    private static final int keepAliveTimeoutValue = 30000;
    private final XNetTrafficController tc;
    private final XNetSystemConnectionMemo memo;

    public XNetHeartBeat(XNetSystemConnectionMemo memo) {
        this.memo = memo;
        this.tc = memo.getXNetTrafficController();
        this.tc.addXNetListener(-1, this);
        this.keepAliveTimer();
    }

    private void keepAliveTimer() {
        if (this.keepAliveTimer == null) {
            this.keepAliveTimer = new Timer(30000, e -> {
                XNetProgrammer p = null;
                if (this.memo.provides(GlobalProgrammerManager.class)) {
                    p = (XNetProgrammer)this.memo.getProgrammerManager().getGlobalProgrammer();
                }
                if (p == null || !p.programmerBusy()) {
                    this.tc.sendXNetMessage(XNetMessage.getCSStatusRequestMessage(), null);
                }
            });
        }
        this.keepAliveTimer.stop();
        this.keepAliveTimer.setInitialDelay(30000);
        this.keepAliveTimer.setRepeats(true);
        this.keepAliveTimer.start();
    }

    public void dispose() {
        this.keepAliveTimer.stop();
        this.keepAliveTimer = null;
    }

    @Override
    public void message(XNetReply msg) {
    }

    @Override
    public void message(XNetMessage msg) {
        this.keepAliveTimer.restart();
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
    }
}

