/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Timer;
import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.ConsistManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.Programmer;
import jmri.ThrottleManager;
import jmri.jmrix.lenz.XNetConsistManager;
import jmri.jmrix.lenz.XNetLightManager;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetPowerManager;
import jmri.jmrix.lenz.XNetProgrammer;
import jmri.jmrix.lenz.XNetProgrammerManager;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSensorManager;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetThrottleManager;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.XNetTurnoutManager;
import jmri.jmrix.roco.RocoXNetThrottleManager;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetInitializationManager {
    private XNetSystemConnectionMemo systemMemo;
    private Class<? extends XNetPowerManager> powerManagerClass;
    private Class<? extends XNetThrottleManager> throttleManagerClass;
    private Class<? extends RocoXNetThrottleManager> rocoThrottleManagerClass;
    private Class<? extends XNetProgrammerManager> programmerManagerClass;
    private Class<? extends XNetProgrammer> programmerClass;
    private Class<? extends XNetConsistManager> consistManagerClass;
    private Class<? extends XNetTurnoutManager> turnoutManagerClass;
    private Class<? extends XNetLightManager> lightManagerClass;
    private Class<? extends XNetSensorManager> sensorManagerClass;
    private boolean versionCheck = false;
    private boolean noCommandStation = false;
    private int initTimeout = 30000;
    private static final Logger log = LoggerFactory.getLogger(XNetInitializationManager.class);

    public XNetInitializationManager versionCheck() {
        this.versionCheck = true;
        return this;
    }

    public XNetInitializationManager setTimeout(int timeout) {
        this.initTimeout = timeout;
        return this;
    }

    public XNetInitializationManager memo(XNetSystemConnectionMemo systemMemo) {
        this.systemMemo = systemMemo;
        return this;
    }

    public XNetInitializationManager setDefaults() {
        this.powerManagerClass = XNetPowerManager.class;
        this.throttleManagerClass = XNetThrottleManager.class;
        this.rocoThrottleManagerClass = RocoXNetThrottleManager.class;
        this.programmerManagerClass = XNetProgrammerManager.class;
        this.programmerClass = XNetProgrammer.class;
        this.consistManagerClass = XNetConsistManager.class;
        this.turnoutManagerClass = XNetTurnoutManager.class;
        this.lightManagerClass = XNetLightManager.class;
        this.sensorManagerClass = XNetSensorManager.class;
        return this;
    }

    public XNetInitializationManager powerManager(Class<? extends XNetPowerManager> powerManagerClass) {
        this.powerManagerClass = powerManagerClass;
        return this;
    }

    private void initPowerManager() {
        if (this.powerManagerClass != null) {
            try {
                Constructor<? extends XNetPowerManager> ctor = this.powerManagerClass.getConstructor(XNetSystemConnectionMemo.class);
                XNetPowerManager pm = ctor.newInstance(this.systemMemo);
                this.systemMemo.setPowerManager(pm);
                InstanceManager.store(pm, PowerManager.class);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to construct power manager for XPressNet connection {}", (Object)this.systemMemo.getSystemPrefix(), (Object)e);
            }
        }
    }

    public XNetInitializationManager programmer(Class<? extends XNetProgrammer> programmerClass) {
        this.programmerClass = programmerClass;
        return this;
    }

    private XNetProgrammer initProgrammer() {
        XNetProgrammer prog = null;
        if (this.programmerClass != null) {
            try {
                Constructor<? extends XNetProgrammer> ctor = this.programmerClass.getConstructor(XNetTrafficController.class);
                prog = ctor.newInstance(this.systemMemo.getXNetTrafficController());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to construct programmer for XPressNet connection {}", (Object)this.systemMemo.getSystemPrefix(), (Object)e);
            }
        }
        return prog;
    }

    public XNetInitializationManager noCommandStation() {
        this.noCommandStation = true;
        return this;
    }

    private void initCommandStation() {
        if (!this.noCommandStation) {
            this.systemMemo.setCommandStation(this.systemMemo.getXNetTrafficController().getCommandStation());
            if (this.systemMemo.getCommandStation() != null) {
                InstanceManager.store(this.systemMemo.getCommandStation(), CommandStation.class);
            }
        }
    }

    public XNetInitializationManager programmerManager(Class<? extends XNetProgrammerManager> programmerManagerClass) {
        this.programmerManagerClass = programmerManagerClass;
        return this;
    }

    private void initProgrammerManager() {
        XNetProgrammer programmer = this.initProgrammer();
        if (this.programmerManagerClass != null && programmer != null) {
            try {
                Constructor<? extends XNetProgrammerManager> ctor = this.programmerManagerClass.getConstructor(Programmer.class, XNetSystemConnectionMemo.class);
                XNetProgrammerManager pm = ctor.newInstance(programmer, this.systemMemo);
                this.systemMemo.setProgrammerManager(pm);
                if (pm.isAddressedModePossible()) {
                    InstanceManager.store(pm, AddressedProgrammerManager.class);
                    this.initCommandStation();
                }
                if (pm.isGlobalProgrammerAvailable()) {
                    InstanceManager.store(pm, GlobalProgrammerManager.class);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to construct programmer manager for XPressNet connection {}", (Object)this.systemMemo.getSystemPrefix(), (Object)e);
            }
        }
    }

    public XNetInitializationManager throttleManager(Class<? extends XNetThrottleManager> throttleManagerClass) {
        this.throttleManagerClass = throttleManagerClass;
        return this;
    }

    private void initThrottleManager() {
        if (this.throttleManagerClass != null) {
            try {
                Constructor<? extends XNetThrottleManager> ctor = this.throttleManagerClass.getConstructor(XNetSystemConnectionMemo.class);
                XNetThrottleManager tm = ctor.newInstance(this.systemMemo);
                this.systemMemo.setThrottleManager(tm);
                InstanceManager.store(tm, ThrottleManager.class);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to construct throttle manager for XPressNet connection {}", (Object)this.systemMemo.getSystemPrefix());
            }
        }
    }

    public XNetInitializationManager rocoThrottleManager(Class<? extends RocoXNetThrottleManager> rocoThrottleManagerClass) {
        this.rocoThrottleManagerClass = rocoThrottleManagerClass;
        return this;
    }

    private void initRocoThrottleManager() {
        if (this.rocoThrottleManagerClass != null) {
            try {
                Constructor<? extends RocoXNetThrottleManager> ctor = this.rocoThrottleManagerClass.getConstructor(XNetSystemConnectionMemo.class);
                RocoXNetThrottleManager tm = ctor.newInstance(this.systemMemo);
                this.systemMemo.setThrottleManager(tm);
                InstanceManager.store(tm, ThrottleManager.class);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to construct throttle manager for XPressNet connection {}", (Object)this.systemMemo.getSystemPrefix());
            }
        }
    }

    public XNetInitializationManager turnoutManager(Class<? extends XNetTurnoutManager> turnoutManagerClass) {
        this.turnoutManagerClass = turnoutManagerClass;
        return this;
    }

    private void initTurnoutManager() {
        if (this.turnoutManagerClass != null) {
            try {
                Constructor<? extends XNetTurnoutManager> ctor = this.turnoutManagerClass.getConstructor(XNetSystemConnectionMemo.class);
                XNetTurnoutManager tm = ctor.newInstance(this.systemMemo);
                this.systemMemo.setTurnoutManager(tm);
                InstanceManager.setTurnoutManager(tm);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to construct turnout manager for XPressNet connection {}", (Object)this.systemMemo.getSystemPrefix());
            }
        }
    }

    public XNetInitializationManager sensorManager(Class<? extends XNetSensorManager> sensorManagerClass) {
        this.sensorManagerClass = sensorManagerClass;
        return this;
    }

    private void initSensorManager() {
        if (this.sensorManagerClass != null) {
            try {
                Constructor<? extends XNetSensorManager> ctor = this.sensorManagerClass.getConstructor(XNetSystemConnectionMemo.class);
                XNetSensorManager sm = ctor.newInstance(this.systemMemo);
                this.systemMemo.setSensorManager(sm);
                InstanceManager.setSensorManager(sm);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to construct sensor manager for XPressNet connection {}", (Object)this.systemMemo.getSystemPrefix());
            }
        }
    }

    public XNetInitializationManager lightManager(Class<? extends XNetLightManager> lightManagerClass) {
        this.lightManagerClass = lightManagerClass;
        return this;
    }

    private void initLightManager() {
        if (this.lightManagerClass != null) {
            try {
                Constructor<? extends XNetLightManager> ctor = this.lightManagerClass.getConstructor(XNetSystemConnectionMemo.class);
                XNetLightManager lm = ctor.newInstance(this.systemMemo);
                this.systemMemo.setLightManager(lm);
                InstanceManager.setLightManager(lm);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to construct light manager for XPressNet connection {}", (Object)this.systemMemo.getSystemPrefix());
            }
        }
    }

    public XNetInitializationManager consistManager(Class<? extends XNetConsistManager> consistManagerClass) {
        this.consistManagerClass = consistManagerClass;
        return this;
    }

    private void initConsistManager() {
        if (this.consistManagerClass != null) {
            try {
                Constructor<? extends XNetConsistManager> ctor = this.consistManagerClass.getConstructor(XNetSystemConnectionMemo.class);
                XNetConsistManager tm = ctor.newInstance(this.systemMemo);
                this.systemMemo.setConsistManager(tm);
                InstanceManager.store(tm, ConsistManager.class);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to construct consist manager for XPressNet connection {}", (Object)this.systemMemo.getSystemPrefix());
            }
        }
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug("Init called");
        }
        this.initPowerManager();
        if (this.versionCheck) {
            this.checkVersionAndInit();
        } else {
            this.initServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVersionAndInit() {
        log.debug("Starting XpressNet Initialization Process");
        new XNetInitializer(this);
        XNetInitializationManager xNetInitializationManager = this;
        synchronized (xNetInitializationManager) {
            log.debug("start wait");
            new WaitHandler(this);
            log.debug("end wait");
        }
        float CSSoftwareVersion = this.systemMemo.getXNetTrafficController().getCommandStation().getCommandStationSoftwareVersion();
        int CSType = this.systemMemo.getXNetTrafficController().getCommandStation().getCommandStationType();
        if (CSSoftwareVersion < 0.0f) {
            log.warn("Command Station disconnected, or powered down assuming LZ100/LZV100 V3.x");
            this.initServices();
        } else if ((double)CSSoftwareVersion < 3.0) {
            log.error("Command Station does not support XpressNet Version 3 Command Set");
            this.initThrottleManager();
        } else if (CSType == 2) {
            log.debug("Command Station is Compact/Commander/Other");
            this.initThrottleManager();
            this.initTurnoutManager();
            this.initLightManager();
            this.initConsistManager();
        } else if (CSType == 1) {
            log.debug("Command Station is LH200");
            this.initThrottleManager();
        } else if (CSType == 0) {
            log.debug("Command Station is LZ100/LZV100");
            this.initServices();
        } else if (CSType == 4) {
            log.debug("Command Station is LokMaus II");
            this.initRocoThrottleManager();
            this.initTurnoutManager();
            this.initLightManager();
            this.initSensorManager();
            this.initProgrammerManager();
        } else if (CSType == 16) {
            log.debug("Command Station is multiMaus");
            this.initRocoThrottleManager();
            this.initTurnoutManager();
            this.initLightManager();
            this.initSensorManager();
            this.initProgrammerManager();
        } else {
            log.debug("Command Station is Unknown type");
            this.initServices();
        }
        log.debug("XpressNet Initialization Complete");
    }

    private void initServices() {
        this.initThrottleManager();
        this.initProgrammerManager();
        this.initConsistManager();
        this.initTurnoutManager();
        this.initLightManager();
        this.initSensorManager();
    }

    protected class XNetInitializer
    implements XNetListener {
        private final Timer initTimer;
        private final Object parent;

        public XNetInitializer(Object Parent2) {
            this.parent = Parent2;
            this.initTimer = this.setupInitTimer();
            XNetInitializationManager.this.systemMemo.getXNetTrafficController().addXNetListener(2, this);
            XNetMessage msg = XNetMessage.getCSVersionRequestMessage();
            XNetInitializationManager.this.systemMemo.getXNetTrafficController().sendXNetMessage(msg, this);
        }

        protected Timer setupInitTimer() {
            Timer retVal = new Timer(XNetInitializationManager.this.initTimeout, e -> {
                if (log.isDebugEnabled()) {
                    log.debug("Timeout waiting for Command Station Response");
                }
                this.finish();
            });
            retVal.setInitialDelay(XNetInitializationManager.this.initTimeout);
            retVal.start();
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"NO_NOTIFY_NOT_NOTIFYALL"}, justification="There should only ever be one thread waiting for this method (the designated parent, which started the thread).")
        private void finish() {
            this.initTimer.stop();
            try {
                Object object = this.parent;
                synchronized (object) {
                    this.parent.notify();
                }
            }
            catch (Exception e) {
                log.error("Exception {] while notifying initialization thread.", (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Notification Sent");
            }
            this.dispose();
        }

        @Override
        public void message(XNetReply l) {
            if (l.getElement(0) == 99 && l.getElement(1) == 33) {
                XNetInitializationManager.this.systemMemo.getXNetTrafficController().getCommandStation().setCommandStationSoftwareVersion(l);
                XNetInitializationManager.this.systemMemo.getXNetTrafficController().getCommandStation().setCommandStationType(l);
                this.finish();
            }
        }

        @Override
        public void message(XNetMessage l) {
        }

        @Override
        public void notifyTimeout(XNetMessage msg) {
            if (log.isDebugEnabled()) {
                log.debug("Notified of timeout on message {}", (Object)msg);
            }
        }

        public void dispose() {
            XNetInitializationManager.this.systemMemo.getXNetTrafficController().removeXNetListener(2, this);
        }
    }
}

