/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.implementation.AbstractLight;
import jmri.jmrix.lenz.XNetLightManager;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetLight
extends AbstractLight
implements XNetListener {
    private XNetTrafficController tc;
    private XNetLightManager lm;
    int mAddress = 0;
    static final int OFFSENT = 1;
    static final int COMMANDSENT = 2;
    static final int IDLE = 0;
    private int internalState = 0;
    private static final Logger log = LoggerFactory.getLogger(XNetLight.class);

    public XNetLight(XNetTrafficController tc, XNetLightManager lm, String systemName) {
        super(systemName);
        this.tc = tc;
        this.lm = lm;
        this.initializeLight(systemName);
    }

    public XNetLight(XNetTrafficController tc, XNetLightManager lm, String systemName, String userName) {
        super(systemName, userName);
        this.tc = tc;
        this.lm = lm;
        this.initializeLight(systemName);
    }

    @Override
    public void dispose() {
        this.tc.removeXNetListener(11, this);
        super.dispose();
    }

    private synchronized void initializeLight(String systemName) {
        this.mAddress = this.lm.getBitFromSystemName(systemName);
        this.setState(4);
        this.tc.addXNetListener(11, this);
    }

    @Override
    public synchronized void setState(int newState) {
        if (newState != 2 && newState != 4) {
            log.warn("Unsupported state {} requested for light {}", (Object)newState, (Object)this.mSystemName);
            return;
        }
        XNetMessage msg = XNetMessage.getTurnoutCommandMsg(this.mAddress, newState == 2, newState == 4, true);
        this.internalState = 2;
        this.tc.sendXNetMessage(msg, this);
        if (newState != this.mState) {
            int oldState = this.mState;
            this.mState = newState;
            this.firePropertyChange("KnownState", oldState, newState);
        }
        this.sendOffMessage();
    }

    @Override
    public synchronized void message(XNetReply l) {
        if (log.isDebugEnabled()) {
            log.debug("received message: {}", (Object)l);
        }
        if (this.internalState == 1) {
            if (l.isCommErrorMessage()) {
                log.error("Communications error occurred - message received was: {}", (Object)l);
                this.sendOffMessage();
            } else if (l.isCSBusyMessage()) {
                log.error("Command station busy - message received was: {}", (Object)l);
                this.sendOffMessage();
            } else if (l.isOkMessage()) {
                this.internalState = 0;
            } else if (this.internalState == 2) {
                if (l.isCommErrorMessage()) {
                    log.error("Communications error occurred - message received was: {}", (Object)l);
                    this.setState(this.mState);
                } else if (l.isCSBusyMessage()) {
                    log.error("Command station busy - message received was: {}", (Object)l);
                    this.setState(this.mState);
                } else if (l.isOkMessage()) {
                    this.sendOffMessage();
                }
            }
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message{}", (Object)msg.toString());
        }
    }

    private synchronized void sendOffMessage() {
        if (log.isDebugEnabled()) {
            log.debug("Sending off message for light {} commanded state= {}", (Object)this.mAddress, (Object)this.mState);
        }
        XNetMessage msg = XNetMessage.getTurnoutCommandMsg(this.mAddress, this.mState == 2, this.mState == 4, false);
        this.tc.sendXNetMessage(msg, this);
        this.internalState = 1;
    }
}

