/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.util.StringUtil;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetMessage
extends AbstractMRMessage
implements Serializable {
    private static int _nRetries = 5;
    protected static final int XNetProgrammingTimeout = 10000;
    private static int XNetMessageTimeout = 5000;
    private boolean broadcastReply = false;
    private static final List<XPressNetMessageFormatter> formatterList = new ArrayList<XPressNetMessageFormatter>();
    private static final Logger log = LoggerFactory.getLogger(XNetMessage.class);

    public XNetMessage(int len) {
        super(len);
        if (len > 15) {
            log.error("Invalid length in ctor: {}", (Object)len);
            throw new IllegalArgumentException("Invalid length in ctor: " + len);
        }
        this.setBinary(true);
        this.setRetries(_nRetries);
        this.setTimeout(XNetMessageTimeout);
        this._nDataChars = len;
    }

    public XNetMessage(XNetMessage message) {
        super(message);
        this.setBinary(true);
        this.setRetries(_nRetries);
        this.setTimeout(XNetMessageTimeout);
    }

    public XNetMessage(XNetReply message) {
        super(message.getNumDataElements());
        this.setBinary(true);
        this.setRetries(_nRetries);
        this.setTimeout(XNetMessageTimeout);
        for (int i = 0; i < message.getNumDataElements(); ++i) {
            this.setElement(i, message.getElement(i));
        }
    }

    public XNetMessage(String s) {
        this.setBinary(true);
        this.setRetries(_nRetries);
        this.setTimeout(XNetMessageTimeout);
        byte[] b = StringUtil.bytesFromHexString(s);
        if (b.length == 0) {
            this._nDataChars = 0;
            this._dataChars = null;
            return;
        }
        this._nDataChars = b.length;
        this._dataChars = new int[this._nDataChars];
        for (int i = 0; i < b.length; ++i) {
            this.setElement(i, b[i]);
        }
    }

    @Override
    public void setOpCode(int i) {
        if (i > 15 || i < 0) {
            log.error("Opcode invalid: {}", (Object)i);
        }
        this.setElement(0, i * 16 & 0xF0 | this.getNumDataElements() - 2 & 0xF);
    }

    @Override
    public int getOpCode() {
        return this.getElement(0) / 16 & 0xF;
    }

    @Override
    public String getOpCodeHex() {
        return "0x" + Integer.toHexString(this.getOpCode());
    }

    public boolean checkParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        for (int loop = 0; loop < len - 1; ++loop) {
            chksum ^= this.getElement(loop);
        }
        return (chksum & 0xFF) == this.getElement(len - 1);
    }

    public void setParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        for (int loop = 0; loop < len - 1; ++loop) {
            chksum ^= this.getElement(loop);
        }
        this.setElement(len - 1, chksum & 0xFF);
    }

    public Integer getElementBCD(int n) {
        return Integer.decode(Integer.toHexString(this.getElement(n)));
    }

    public int length() {
        return this._nDataChars;
    }

    public static void setXNetMessageRetries(int t) {
        _nRetries = t;
    }

    public static void setXNetMessageTimeout(int t) {
        XNetMessageTimeout = t;
    }

    @Override
    public boolean replyExpected() {
        return !this.broadcastReply;
    }

    public void setBroadcastReply() {
        this.broadcastReply = true;
    }

    public static XNetMessage getNMRAXNetMsg(byte[] packet) {
        XNetMessage msg = new XNetMessage(packet.length + 2);
        msg.setOpCode(14);
        msg.setElement(1, 48);
        for (int i = 0; i < packet.length; ++i) {
            msg.setElement(i + 2, packet[i] & 0xFF);
        }
        msg.setParity();
        return msg;
    }

    public static XNetMessage getTurnoutCommandMsg(int pNumber, boolean pClose, boolean pThrow, boolean pOn) {
        XNetMessage l = new XNetMessage(4);
        l.setElement(0, 82);
        int hiadr = (pNumber - 1) / 4;
        int loadr = (pNumber - 1 - hiadr * 4) * 2;
        loadr = !pOn ? (loadr |= 0x80) : (loadr |= 0x88);
        if (pThrow) {
            loadr |= 1;
        }
        if (pClose && pThrow) {
            log.error("XpressNet turnout logic can't handle both THROWN and CLOSED yet");
        }
        l.setElement(1, hiadr);
        l.setElement(2, loadr);
        l.setParity();
        return l;
    }

    public static XNetMessage getFeedbackRequestMsg(int pNumber, boolean pLowerNibble) {
        XNetMessage l = new XNetMessage(4);
        l.setBroadcastReply();
        l.setElement(0, 66);
        l.setElement(1, (pNumber - 1) / 4);
        if (pLowerNibble) {
            l.setElement(2, 128);
        } else {
            l.setElement(2, 129);
        }
        l.setParity();
        return l;
    }

    public static XNetMessage getServiceModeResultsMsg() {
        XNetMessage m = new XNetMessage(3);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 33);
        m.setElement(1, 16);
        m.setParity();
        return m;
    }

    public static XNetMessage getExitProgModeMsg() {
        XNetMessage m = new XNetMessage(3);
        m.setNeededMode(4);
        m.setElement(0, 33);
        m.setElement(1, 129);
        m.setParity();
        return m;
    }

    public static XNetMessage getReadPagedCVMsg(int cv) {
        XNetMessage m = new XNetMessage(4);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 34);
        m.setElement(1, 20);
        m.setElement(2, 0xFF & cv);
        m.setParity();
        return m;
    }

    public static XNetMessage getReadDirectCVMsg(int cv) {
        XNetMessage m = new XNetMessage(4);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 34);
        if (cv < 256) {
            m.setElement(1, 21);
        } else if (cv == 1024) {
            m.setElement(1, 24);
        } else {
            m.setElement(1, 0x18 | (cv & 0x300) >> 8);
        }
        m.setElement(2, 0xFF & cv);
        m.setParity();
        return m;
    }

    public static XNetMessage getWritePagedCVMsg(int cv, int val) {
        XNetMessage m = new XNetMessage(5);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 35);
        m.setElement(1, 23);
        m.setElement(2, 0xFF & cv);
        m.setElement(3, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getWriteDirectCVMsg(int cv, int val) {
        XNetMessage m = new XNetMessage(5);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 35);
        if (cv < 256) {
            m.setElement(1, 22);
        } else if (cv == 1024) {
            m.setElement(1, 28);
        } else {
            m.setElement(1, 0x1C | (cv & 0x300) >> 8);
        }
        m.setElement(2, 0xFF & cv);
        m.setElement(3, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getReadRegisterMsg(int reg) {
        if (reg > 8) {
            log.error("register number too large: {}", (Object)reg);
        }
        XNetMessage m = new XNetMessage(4);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 34);
        m.setElement(1, 17);
        m.setElement(2, 0xF & reg);
        m.setParity();
        return m;
    }

    public static XNetMessage getWriteRegisterMsg(int reg, int val) {
        if (reg > 8) {
            log.error("register number too large: {}", (Object)reg);
        }
        XNetMessage m = new XNetMessage(5);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 35);
        m.setElement(1, 18);
        m.setElement(2, 0xF & reg);
        m.setElement(3, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getWriteOpsModeCVMsg(int AH, int AL2, int cv, int val) {
        XNetMessage m = new XNetMessage(8);
        m.setElement(0, 230);
        m.setElement(1, 48);
        m.setElement(2, AH);
        m.setElement(3, AL2);
        int temp = cv - 1 & 0x300;
        m.setElement(4, 236 + (temp /= 255));
        m.setElement(5, (0xFF & cv) - 1);
        m.setElement(6, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getVerifyOpsModeCVMsg(int AH, int AL2, int cv, int val) {
        XNetMessage m = new XNetMessage(8);
        m.setElement(0, 230);
        m.setElement(1, 48);
        m.setElement(2, AH);
        m.setElement(3, AL2);
        int temp = cv - 1 & 0x300;
        m.setElement(4, 228 + (temp /= 255));
        m.setElement(5, (0xFF & cv) - 1);
        m.setElement(6, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getBitWriteOpsModeCVMsg(int AH, int AL2, int cv, int bit, boolean value) {
        XNetMessage m = new XNetMessage(8);
        m.setElement(0, 230);
        m.setElement(1, 48);
        m.setElement(2, AH);
        m.setElement(3, AL2);
        int temp = cv - 1 & 0x300;
        m.setElement(4, 232 + (temp /= 255));
        m.setElement(5, (0xFF & cv) - 1);
        if (value) {
            m.setElement(6, 0xE8 | bit & 0xFF);
        } else {
            m.setElement(6, 0xE0 | bit & 0xFF);
        }
        m.setParity();
        return m;
    }

    public static XNetMessage getBitVerifyOpsModeCVMsg(int AH, int AL2, int cv, int bit, boolean value) {
        XNetMessage m = new XNetMessage(8);
        m.setElement(0, 230);
        m.setElement(1, 48);
        m.setElement(2, AH);
        m.setElement(3, AL2);
        int temp = cv - 1 & 0x300;
        m.setElement(4, 232 + (temp /= 255));
        m.setElement(5, (0xFF & cv) - 1);
        if (value) {
            m.setElement(6, 0xF8 | bit & 0xFF);
        } else {
            m.setElement(6, 0xF0 | bit & 0xFF);
        }
        m.setParity();
        return m;
    }

    public static XNetMessage getBuildDoubleHeaderMsg(int address1, int address2) {
        XNetMessage msg = new XNetMessage(7);
        msg.setElement(0, 229);
        msg.setElement(1, 67);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address1));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address1));
        msg.setElement(4, LenzCommandStation.getDCCAddressHigh(address2));
        msg.setElement(5, LenzCommandStation.getDCCAddressLow(address2));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getDisolveDoubleHeaderMsg(int address) {
        return XNetMessage.getBuildDoubleHeaderMsg(address, 0);
    }

    public static XNetMessage getAddLocoToConsistMsg(int consist, int address, boolean isNormalDir) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        if (isNormalDir) {
            msg.setElement(1, 64);
        } else {
            msg.setElement(1, 65);
        }
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setElement(4, consist);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getRemoveLocoFromConsistMsg(int consist, int address) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 66);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setElement(4, consist);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getNextAddressOnStackMsg(int address, boolean searchForward) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        if (searchForward) {
            msg.setElement(1, 5);
        } else {
            msg.setElement(1, 6);
        }
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getDBSearchMsgConsistAddress(int address, boolean searchForward) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 226);
        if (searchForward) {
            msg.setElement(1, 3);
        } else {
            msg.setElement(1, 4);
        }
        msg.setElement(2, address);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getDBSearchMsgNextMULoco(int consist, int address, boolean searchForward) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        if (searchForward) {
            msg.setElement(1, 1);
        } else {
            msg.setElement(1, 2);
        }
        msg.setElement(2, consist);
        msg.setElement(3, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(4, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getDeleteAddressOnStackMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 68);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLocomotiveInfoRequestMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 0);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLocomotiveFunctionStatusMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 7);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLocomotiveFunctionHighOnStatusMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 9);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLocomotiveFunctionHighMomStatusMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 8);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getAddressedEmergencyStop(int address) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 146);
        msg.setElement(1, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(2, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getSpeedAndDirectionMsg(int address, SpeedStepMode speedStepMode, float speed, boolean isForward) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        int element4value = 0;
        if (speedStepMode == SpeedStepMode.NMRA_DCC_128) {
            msg.setElement(1, 19);
            int speedVal = Math.round(speed * 126.0f);
            if (speedVal >= 1) {
                element4value = speedVal + 1;
            }
        } else if (speedStepMode == SpeedStepMode.NMRA_DCC_28) {
            msg.setElement(1, 18);
            int speedVal = Math.round(speed * 28.0f);
            if (speedVal >= 1) {
                speedVal += 3;
            }
            element4value = ((speedVal & 0x1E) >> 1) + ((speedVal & 1) << 4);
        } else if (speedStepMode == SpeedStepMode.NMRA_DCC_27) {
            msg.setElement(1, 17);
            int speedVal = Math.round(speed * 27.0f);
            if (speedVal >= 1) {
                speedVal += 3;
            }
            element4value = ((speedVal & 0x1E) >> 1) + ((speedVal & 1) << 4);
        } else {
            msg.setElement(1, 16);
            element4value = (int)(speed * 14.0f);
            int speedVal = Math.round(speed * 14.0f);
            if (speedVal >= 1) {
                ++element4value;
            }
        }
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        if (isForward) {
            element4value += 128;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup1OpsMsg(int address, boolean f0, boolean f1, boolean f2, boolean f3, boolean f4) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 32);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f0) {
            element4value += 16;
        }
        if (f1) {
            ++element4value;
        }
        if (f2) {
            element4value += 2;
        }
        if (f3) {
            element4value += 4;
        }
        if (f4) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup1SetMomMsg(int address, boolean f0, boolean f1, boolean f2, boolean f3, boolean f4) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 36);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f0) {
            element4value += 16;
        }
        if (f1) {
            ++element4value;
        }
        if (f2) {
            element4value += 2;
        }
        if (f3) {
            element4value += 4;
        }
        if (f4) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup2OpsMsg(int address, boolean f5, boolean f6, boolean f7, boolean f8) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 33);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f5) {
            ++element4value;
        }
        if (f6) {
            element4value += 2;
        }
        if (f7) {
            element4value += 4;
        }
        if (f8) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup2SetMomMsg(int address, boolean f5, boolean f6, boolean f7, boolean f8) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 37);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f5) {
            ++element4value;
        }
        if (f6) {
            element4value += 2;
        }
        if (f7) {
            element4value += 4;
        }
        if (f8) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup3OpsMsg(int address, boolean f9, boolean f10, boolean f11, boolean f12) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 34);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f9) {
            ++element4value;
        }
        if (f10) {
            element4value += 2;
        }
        if (f11) {
            element4value += 4;
        }
        if (f12) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup3SetMomMsg(int address, boolean f9, boolean f10, boolean f11, boolean f12) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 38);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f9) {
            ++element4value;
        }
        if (f10) {
            element4value += 2;
        }
        if (f11) {
            element4value += 4;
        }
        if (f12) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup4OpsMsg(int address, boolean f13, boolean f14, boolean f15, boolean f16, boolean f17, boolean f18, boolean f19, boolean f20) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 35, f13, f14, f15, f16, f17, f18, f19, f20);
    }

    public static XNetMessage getFunctionGroup4SetMomMsg(int address, boolean f13, boolean f14, boolean f15, boolean f16, boolean f17, boolean f18, boolean f19, boolean f20) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 39, f13, f14, f15, f16, f17, f18, f19, f20);
    }

    public static XNetMessage getFunctionGroup5OpsMsg(int address, boolean f21, boolean f22, boolean f23, boolean f24, boolean f25, boolean f26, boolean f27, boolean f28) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 40, f21, f22, f23, f24, f25, f26, f27, f28);
    }

    public static XNetMessage getFunctionGroup5SetMomMsg(int address, boolean f21, boolean f22, boolean f23, boolean f24, boolean f25, boolean f26, boolean f27, boolean f28) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 44, f21, f22, f23, f24, f25, f26, f27, f28);
    }

    private static XNetMessage getFunctionGroupNOpsMsg(int address, int byte1, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, byte1);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (fA) {
            ++element4value;
        }
        if (fB) {
            element4value += 2;
        }
        if (fC) {
            element4value += 4;
        }
        if (fD) {
            element4value += 8;
        }
        if (fE) {
            element4value += 16;
        }
        if (fF) {
            element4value += 32;
        }
        if (fG) {
            element4value += 64;
        }
        if (fH) {
            element4value += 128;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup6OpsMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 41, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getFunctionGroup7OpsMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 42, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getFunctionGroup8OpsMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 43, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getFunctionGroup9OpsMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 80, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getFunctionGroup10OpsMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 81, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getFunctionGroup6SetMomMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 45, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getFunctionGroup7SetMomMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 46, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getFunctionGroup8SetMomMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 82, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getFunctionGroup9SetMomMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 83, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getFunctionGroup10SetMomMsg(int address, boolean fA, boolean fB, boolean fC, boolean fD, boolean fE, boolean fF, boolean fG, boolean fH) {
        return XNetMessage.getFunctionGroupNOpsMsg(address, 84, fA, fB, fC, fD, fE, fF, fG, fH);
    }

    public static XNetMessage getResumeOperationsMsg() {
        XNetMessage msg = new XNetMessage(3);
        msg.setElement(0, 33);
        msg.setElement(1, 129);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getEmergencyOffMsg() {
        XNetMessage msg = new XNetMessage(3);
        msg.setElement(0, 33);
        msg.setElement(1, 128);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getEmergencyStopMsg() {
        XNetMessage msg = new XNetMessage(2);
        msg.setElement(0, 128);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getCSVersionRequestMessage() {
        XNetMessage msg = new XNetMessage(3);
        msg.setElement(0, 33);
        msg.setElement(1, 33);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getCSStatusRequestMessage() {
        XNetMessage msg = new XNetMessage(3);
        msg.setElement(0, 33);
        msg.setElement(1, 36);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getCSAutoStartMessage(boolean autoMode) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 34);
        msg.setElement(1, 34);
        if (autoMode) {
            msg.setElement(2, 4);
        } else {
            msg.setElement(2, 0);
        }
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLIVersionRequestMessage() {
        XNetMessage msg = new XNetMessage(2);
        msg.setElement(0, 240);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLIAddressRequestMsg(int address) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 242);
        msg.setElement(1, 1);
        msg.setElement(2, address);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLISpeedRequestMsg(int speed) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 242);
        msg.setElement(1, 2);
        msg.setElement(2, speed);
        msg.setParity();
        return msg;
    }

    @Override
    public String toMonitorString() {
        if (formatterList.isEmpty()) {
            try {
                Reflections reflections = new Reflections("jmri.jmrix", new Scanner[0]);
                Set f2 = reflections.getSubTypesOf(XPressNetMessageFormatter.class);
                for (Class c : f2) {
                    log.debug("Found formatter: {}", (Object)f2.getClass().getName());
                    Constructor ctor = c.getConstructor(new Class[0]);
                    formatterList.add((XPressNetMessageFormatter)ctor.newInstance(new Object[0]));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Error instantiating formatter", (Throwable)e);
            }
        }
        return formatterList.stream().filter(f -> f.handlesMessage(this)).findFirst().map(f -> f.formatMessage(this)).orElse(this.toString());
    }
}

