/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetProgrammer
extends AbstractProgrammer
implements XNetListener {
    protected static final int XNetProgrammerTimeout = 90000;
    protected boolean _service_mode = false;
    protected int progState = 0;
    protected static final int NOTPROGRAMMING = 0;
    protected static final int REQUESTSENT = 1;
    protected static final int INQUIRESENT = 2;
    protected boolean _progRead = false;
    protected int _val;
    protected int _cv;
    private ProgListener _usingProgrammer = null;
    XNetTrafficController _controller;
    private static final Logger log = LoggerFactory.getLogger(XNetProgrammer.class);

    public XNetProgrammer(XNetTrafficController tc) {
        this._controller = tc;
        this.controller().addXNetListener(67, this);
        this.setMode(ProgrammingMode.DIRECTBYTEMODE);
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.DIRECTBYTEMODE);
        ret.add(ProgrammingMode.DIRECTBITMODE);
        ret.add(ProgrammingMode.PAGEMODE);
        ret.add(ProgrammingMode.REGISTERMODE);
        return ret;
    }

    @Override
    public boolean getCanRead(String addr) {
        if (log.isDebugEnabled()) {
            log.debug("check mode {} CV {}", (Object)this.getMode(), (Object)addr);
        }
        if (!this.getCanRead()) {
            return false;
        }
        if (this.controller().getCommandStation().getCommandStationType() == 16) {
            return false;
        }
        if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            switch (this.controller().getCommandStation().getCommandStationType()) {
                case 0: {
                    if ((double)this.controller().getCommandStation().getCommandStationSoftwareVersion() <= 3.5) {
                        return Integer.parseInt(addr) <= 256;
                    }
                    return Integer.parseInt(addr) <= 1024;
                }
            }
            return Integer.parseInt(addr) <= 256;
        }
        return Integer.parseInt(addr) <= 256;
    }

    @Override
    public boolean getCanWrite(String addr) {
        if (log.isDebugEnabled()) {
            log.debug("check CV {} ", (Object)addr);
            log.debug("Command Station Version {}", (Object)this.controller().getCommandStation().getVersionString());
        }
        if (!this.getCanWrite()) {
            return false;
        }
        if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            switch (this.controller().getCommandStation().getCommandStationType()) {
                case 0: {
                    if ((double)this.controller().getCommandStation().getCommandStationSoftwareVersion() <= 3.5) {
                        return Integer.parseInt(addr) <= 256;
                    }
                    return Integer.parseInt(addr) <= 1024;
                }
            }
            return Integer.parseInt(addr) <= 256;
        }
        return Integer.parseInt(addr) <= 256;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("writeCV {} listens {} ", (Object)CV, (Object)p);
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 1;
        this._val = val;
        this._cv = 0xFFFF & CV;
        try {
            this.restartTimer(90000);
            if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
                XNetMessage msg = XNetMessage.getWritePagedCVMsg(CV, val);
                this.controller().sendXNetMessage(msg, this);
            } else if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
                XNetMessage msg = XNetMessage.getWriteDirectCVMsg(CV, val);
                this.controller().sendXNetMessage(msg, this);
            } else {
                XNetMessage msg = XNetMessage.getWriteRegisterMsg(this.registerFromCV(CV), val);
                this.controller().sendXNetMessage(msg, this);
            }
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("readCV {} listenes {}", (Object)CV, (Object)p);
        if (!this.getCanRead()) {
            this.notifyProgListenerEnd(p, CV, 8);
            return;
        }
        this.useProgrammer(p);
        this._cv = 0xFFFF & CV;
        this._progRead = true;
        this.progState = 1;
        try {
            this.restartTimer(90000);
            if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
                XNetMessage msg = XNetMessage.getReadPagedCVMsg(CV);
                this.controller().sendXNetMessage(msg, this);
            } else if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
                XNetMessage msg = XNetMessage.getReadDirectCVMsg(CV);
                this.controller().sendXNetMessage(msg, this);
            } else {
                XNetMessage msg = XNetMessage.getReadRegisterMsg(this.registerFromCV(CV));
                this.controller().sendXNetMessage(msg, this);
            }
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public synchronized void message(XNetReply m) {
        if (m.getElement(0) == 97 && m.getElement(1) == 2) {
            if (!this._service_mode) {
                this._service_mode = true;
            } else {
                return;
            }
        }
        if (m.getElement(0) == 97 && m.getElement(1) == 1) {
            if (this._service_mode) {
                this._service_mode = false;
            } else {
                return;
            }
        }
        if (this.progState != 0) {
            if (this.progState == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("reply in REQUESTSENT state");
                }
                if (this._service_mode && (m.isOkMessage() || m.isTimeSlotRestored()) || m.getElement(0) == 97 && (m.getElement(1) == 2 || m.getElement(1) == 17)) {
                    if (!this.getCanRead()) {
                        this.restartTimer(this.SHORT_TIMEOUT);
                        return;
                    }
                    this.progState = 2;
                    this.restartTimer(90000);
                    this.controller().sendXNetMessage(XNetMessage.getServiceModeResultsMsg(), this);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 130) {
                    this.progState = 0;
                    this.notifyProgListenerEnd(this._val, 8);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 1) {
                    log.error("Service mode exited before sequence complete.");
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 512);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 18) {
                    log.error("Short Circuit While Programming Decoder");
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 256);
                } else if (!m.isTimeSlotErrorMessage() && m.isCommErrorMessage() && this._controller.hasTimeSlot()) {
                    log.error("Communications error in REQUESTSENT state while programming.  Error: {}", (Object)m);
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 1024);
                }
            } else if (this.progState == 2) {
                if (log.isDebugEnabled()) {
                    log.debug("reply in INQUIRESENT state");
                }
                if (m.isPagedModeResponse()) {
                    try {
                        if (m.getServiceModeCVNumber() != this._cv && m.getServiceModeCVNumber() != this.registerFromCV(this._cv)) {
                            log.debug(" result for CV {} expecting {}", (Object)m.getServiceModeCVNumber(), (Object)this._cv);
                            return;
                        }
                    }
                    catch (ProgrammerException e) {
                        this.progState = 0;
                        this.notifyProgListenerEnd(this._val, 1);
                    }
                    if (this._progRead) {
                        this._val = m.getServiceModeCVValue();
                    }
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 0);
                } else if (m.isDirectModeResponse()) {
                    if (m.getServiceModeCVNumber() != this._cv) {
                        log.debug(" CV read {} expecting {}", (Object)m.getServiceModeCVNumber(), (Object)this._cv);
                        return;
                    }
                    if (this._progRead) {
                        this._val = m.getServiceModeCVValue();
                    }
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 0);
                } else if (m.getElement(0) == 99 && (m.getElement(1) & 0x14) == 20) {
                    int sent_cv = m.getServiceModeCVNumber();
                    if (sent_cv != this._cv && sent_cv == 0 && this._cv != 1024) {
                        return;
                    }
                    if (this._progRead) {
                        this._val = m.getServiceModeCVValue();
                    }
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 0);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 19) {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 2);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 1) {
                    log.error("Service Mode exited before sequence complete.");
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 512);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 18) {
                    log.error("Short Circuit While Programming Decoder");
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 256);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 31) {
                    this.controller().sendXNetMessage(XNetMessage.getServiceModeResultsMsg(), this);
                } else if (!m.isTimeSlotErrorMessage()) {
                    if (m.isCommErrorMessage()) {
                        if (this._controller.hasTimeSlot()) {
                            log.error("Communications error in INQUIRESENT state while programming.  Error: {}", (Object)m);
                            this.progState = 0;
                            this.stopTimer();
                            this.notifyProgListenerEnd(this._val, 1024);
                        }
                    } else {
                        log.debug("Ignoring message {}", (Object)m);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug("reply in un-decoded state");
            }
        }
    }

    @Override
    public synchronized void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message {}", (Object)msg);
    }

    public synchronized boolean programmerBusy() {
        return this.progState != 0;
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            if (this.getCanRead()) {
                this.notifyProgListenerEnd(this._val, 128);
            } else {
                this.notifyProgListenerEnd(this._val, 0);
            }
        }
    }

    protected void notifyProgListenerEnd(int value, int status) {
        log.debug("notifyProgListenerEnd value {} status {}.", (Object)value, (Object)status);
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }

    protected XNetTrafficController controller() {
        return this._controller;
    }
}

