/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.lenz.FeedbackItem;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.util.StringUtil;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetReply
extends AbstractMRReply {
    private static final int FEEDBACK_TURNOUT_MASK = 80;
    private static final int FEEDBACK_MODULE_MASK = 112;
    private static final int FEEDBACK_TYPE_FBMODULE = 64;
    private static final int FEEDBACK_HIGH_NIBBLE = 16;
    private static final List<XPressNetMessageFormatter> formatterList = new ArrayList<XPressNetMessageFormatter>();
    private static final Logger log = LoggerFactory.getLogger(XNetReply.class);

    public XNetReply() {
        this.setBinary(true);
    }

    public XNetReply(XNetReply reply) {
        super(reply);
        this.setBinary(true);
    }

    public XNetReply(XNetMessage message) {
        this.setBinary(true);
        for (int i = 0; i < message.getNumDataElements(); ++i) {
            this.setElement(i, message.getElement(i));
        }
    }

    public XNetReply(String message) {
        this.setBinary(true);
        byte[] b = StringUtil.bytesFromHexString(message);
        if (b.length == 0) {
            this._nDataChars = 0;
            this._dataChars = null;
            return;
        }
        this._nDataChars = b.length;
        this._dataChars = new int[this._nDataChars];
        for (int i = 0; i < b.length; ++i) {
            this.setElement(i, b[i] & 0xFF);
        }
    }

    public String getOpCodeHex() {
        return "0x" + Integer.toHexString(this.getOpCode());
    }

    public boolean checkParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        for (int loop = 0; loop < len - 1; ++loop) {
            chksum ^= this.getElement(loop);
        }
        return (chksum & 0xFF) == this.getElement(len - 1);
    }

    public void setParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        for (int loop = 0; loop < len - 1; ++loop) {
            chksum ^= this.getElement(loop);
        }
        this.setElement(len - 1, chksum & 0xFF);
    }

    public Integer getElementBCD(int n) {
        return Integer.decode(Integer.toHexString(this.getElement(n)));
    }

    @Override
    protected int skipPrefix(int index) {
        return -1;
    }

    public int getTurnoutMsgAddr() {
        if (this.isFeedbackMessage()) {
            return this.getTurnoutAddrFromData(this.getElement(1), this.getElement(2));
        }
        return -1;
    }

    private int getTurnoutAddrFromData(int a1, int a2) {
        if (this.getFeedbackMessageType() > 1) {
            return -1;
        }
        int address = (a1 & 0xFF) * 4 + 1;
        if ((a2 & 0x10) != 0) {
            address += 2;
        }
        return address;
    }

    public int getTurnoutMsgAddr(int startByte) {
        if (this.isFeedbackBroadcastMessage()) {
            int a1 = this.getElement(startByte);
            int a2 = this.getElement(startByte + 1);
            return this.getTurnoutAddrFromData(a1, a2);
        }
        return -1;
    }

    public int getTurnoutStatus(int turnout) {
        if (this.isFeedbackMessage() && (turnout == 0 || turnout == 1)) {
            int a2 = this.getElement(2);
            return this.createFeedbackItem(turnout, a2).getTurnoutStatus();
        }
        return -1;
    }

    public int getTurnoutStatus(int startByte, int turnout) {
        if (this.isFeedbackBroadcastMessage() && (turnout == 0 || turnout == 1)) {
            int a2 = this.getElement(startByte + 1);
            return this.createFeedbackItem(turnout, a2).getTurnoutStatus();
        }
        return -1;
    }

    public int getFeedbackEncoderMsgAddr() {
        if (this.isFeedbackMessage()) {
            int a1 = this.getElement(1);
            int messagetype = this.getFeedbackMessageType();
            if (messagetype == 2) {
                return a1 & 0xFF;
            }
            return -1;
        }
        return -1;
    }

    public final int getFeedbackMessageItems() {
        if (this.isFeedbackMessage()) {
            return 1;
        }
        if (this.isFeedbackBroadcastMessage()) {
            return (this.getElement(0) & 0xF) / 2;
        }
        return 0;
    }

    public int getFeedbackEncoderMsgAddr(int startByte) {
        if (this.isFeedbackBroadcastMessage()) {
            int a1 = this.getElement(startByte);
            int messagetype = this.getFeedbackMessageType(startByte);
            if (messagetype == 2) {
                return a1 & 0xFF;
            }
            return -1;
        }
        return -1;
    }

    public boolean isFeedbackMessage() {
        return this.getElement(0) == 66;
    }

    public boolean isFeedbackBroadcastMessage() {
        return (this.getElement(0) & 0xF0) == 64;
    }

    public int getFeedbackMessageType() {
        if (this.isFeedbackMessage()) {
            int a2 = this.getElement(2);
            return (a2 & 0x60) / 32;
        }
        return -1;
    }

    public int getFeedbackMessageType(int startByte) {
        if (this.isFeedbackBroadcastMessage()) {
            int a2 = this.getElement(startByte + 1);
            return (a2 & 0x60) / 32;
        }
        return -1;
    }

    public boolean isFeedbackMotionComplete(int startByte) {
        int messageType = this.getFeedbackMessageType(startByte);
        if (messageType == 1) {
            int a2 = this.getElement(startByte + 1);
            return (a2 & 0x80) != 128;
        }
        return false;
    }

    public int getThrottleMsgAddr() {
        if (this.isThrottleMessage()) {
            int a1 = this.getElement(2);
            int a2 = this.getElement(3);
            if (a1 == 0) {
                return a2;
            }
            return (a1 * 256 & 0xFF00) + (a2 & 0xFF) - 49152;
        }
        return -1;
    }

    public boolean isThrottleMessage() {
        int message = this.getElement(0);
        return message == 228 || message == 227 || message == 229 || message == 226 || message == 230 || message == 131 || message == 132 || message == 163 || message == 164;
    }

    public boolean isThrottleTakenOverMessage() {
        return this.getElement(0) == 227 && this.getElement(1) == 64;
    }

    public boolean isConsistMessage() {
        int message = this.getElement(0);
        return message == 225 || message == 197 || message == 198;
    }

    public boolean isOkMessage() {
        return this.getElement(0) == 1 && this.getElement(1) == 4;
    }

    public boolean isTimeSlotRestored() {
        return this.getElement(0) == 1 && this.getElement(1) == 7;
    }

    public boolean isTimeSlotRevoked() {
        return this.getElement(0) == 1 && this.getElement(1) == 5;
    }

    public boolean isCSBusyMessage() {
        return this.getElement(0) == 97 && this.getElement(1) == 129;
    }

    public boolean isCSTransferError() {
        return this.getElement(0) == 97 && this.getElement(1) == 128;
    }

    public boolean isUnsupportedError() {
        return this.getElement(0) == 97 && this.getElement(1) == 130;
    }

    public boolean isCommErrorMessage() {
        return this.getElement(0) == 1 && (this.getElement(1) == 3 || this.getElement(1) == 2 || this.getElement(1) == 1 || this.getElement(1) == 10 || this.getElement(1) == 6) || this.isTimeSlotErrorMessage();
    }

    public boolean isTimeSlotErrorMessage() {
        return this.getElement(0) == 1 && (this.getElement(1) == 8 || this.getElement(1) == 7 || this.getElement(1) == 5);
    }

    public boolean isServiceModeResponse() {
        return this.getElement(0) == 99 && (this.getElement(1) == 20 || this.getElement(1) == 21 || this.getElement(1) == 22 || this.getElement(1) == 23 || this.getElement(1) == 16);
    }

    public boolean isPagedModeResponse() {
        return this.getElement(0) == 99 && this.getElement(1) == 16;
    }

    public boolean isDirectModeResponse() {
        return this.getElement(0) == 99 && (this.getElement(1) == 20 || this.getElement(1) == 21 || this.getElement(1) == 22 || this.getElement(1) == 23);
    }

    public int getServiceModeCVNumber() {
        int cv = -1;
        if (this.isServiceModeResponse()) {
            cv = (this.getElement(1) & 0x14) == 20 ? (this.getElement(1) - 20) * 256 + this.getElement(2) : this.getElement(2);
        }
        return cv;
    }

    public int getServiceModeCVValue() {
        int value = -1;
        if (this.isServiceModeResponse()) {
            value = this.getElement(3);
        }
        return value;
    }

    @Override
    public boolean isRetransmittableErrorMsg() {
        return this.isCSBusyMessage() || this.isCommErrorMessage() || this.isCSTransferError();
    }

    @Override
    public boolean isUnsolicited() {
        return super.isUnsolicited() || this.isThrottleTakenOverMessage();
    }

    private int findFeedbackData(int baseAddress, int selector, int mask) {
        if (this.isFeedbackMessage()) {
            int data = this.getElement(2);
            if (this.getElement(1) == baseAddress && (data & mask) == selector) {
                return data;
            }
        } else {
            int start = 1;
            int cnt = this.getFeedbackMessageItems();
            while (cnt > 0) {
                int data = this.getElement(start + 1);
                if (this.getElement(start) == baseAddress && (data & mask) == selector) {
                    return data;
                }
                --cnt;
                start += 2;
            }
        }
        return -1;
    }

    @CheckForNull
    public Boolean selectModuleFeedback(int sensorNumber) {
        if (!this.isFeedbackBroadcastMessage() || sensorNumber == 0 || sensorNumber >= 1024) {
            return null;
        }
        int s = sensorNumber - 1;
        int baseAddress = s / 8;
        int selector2 = (s & 4) != 0 ? 80 : 64;
        int res = this.findFeedbackData(baseAddress, selector2, 112);
        return res == -1 ? null : Boolean.valueOf((res & 1 << s % 4) > 0);
    }

    public boolean onTurnoutFeedback(int accessoryNumber, Function<FeedbackItem, Boolean> proc) {
        return this.selectTurnoutFeedback(accessoryNumber).map(proc).orElse(false);
    }

    @Nonnull
    public Optional<FeedbackItem> selectTurnoutFeedback(int accessoryNumber) {
        if (!this.isFeedbackBroadcastMessage() || accessoryNumber <= 0 || accessoryNumber >= 1024) {
            return Optional.empty();
        }
        int a = accessoryNumber - 1;
        int base = a / 4;
        int selector2 = (a & 2) != 0 ? 16 : 0;
        int r = this.findFeedbackData(base, selector2, 80);
        if (r == -1) {
            return Optional.empty();
        }
        FeedbackItem item = new FeedbackItem(this, accessoryNumber, r);
        return Optional.of(item);
    }

    protected final FeedbackItem createFeedbackItem(int n, int d) {
        return new FeedbackItem(this, n, d);
    }

    @Override
    public String toMonitorString() {
        if (formatterList.isEmpty()) {
            try {
                Reflections reflections = new Reflections("jmri.jmrix", new Scanner[0]);
                Set f2 = reflections.getSubTypesOf(XPressNetMessageFormatter.class);
                for (Class c : f2) {
                    log.debug("Found formatter: {}", (Object)f2.getClass().getName());
                    Constructor ctor = c.getConstructor(new Class[0]);
                    formatterList.add((XPressNetMessageFormatter)ctor.newInstance(new Object[0]));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Error instantiating formatter", (Throwable)e);
            }
        }
        return formatterList.stream().filter(f -> f.handlesMessage(this)).findFirst().map(f -> f.formatMessage(this)).orElse(this.toString());
    }
}

