/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetPortController;
import jmri.jmrix.lenz.XNetReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetTimeSlotListener
implements XNetListener {
    private XNetPortController port;
    private static final Logger log = LoggerFactory.getLogger(XNetTimeSlotListener.class);

    public XNetTimeSlotListener(XNetPortController p) {
        this.port = p;
        log.debug("Time Slot Listener created");
    }

    @Override
    public void message(XNetReply msg) {
        log.debug("Time Slot Listener received {}", (Object)msg);
        if (msg.isTimeSlotErrorMessage()) {
            if (msg.isTimeSlotRevoked()) {
                log.debug("Time Slot Revoked Received");
                this.port.setTimeSlot(false);
            } else if (msg.isTimeSlotRestored()) {
                log.debug("Time Slot Restored Received");
                this.port.setTimeSlot(true);
            } else {
                log.debug("Message Sent while we had no timeslot");
                this.port.setTimeSlot(false);
            }
        }
    }

    @Override
    public void message(XNetMessage msg) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
    }
}

