/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetFeedbackMessageCache;
import jmri.jmrix.lenz.XNetInterface;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetPortController;
import jmri.jmrix.lenz.XNetProgrammer;
import jmri.jmrix.lenz.XNetProgrammerManager;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTimeSlotListener;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XNetTrafficController
extends AbstractMRTrafficController
implements XNetInterface {
    @GuardedBy(value="this")
    protected final HashMap<XNetListener, Integer> mListenerMasks;
    static XNetTrafficController self = null;
    final LinkedBlockingQueue<XNetMessage> highPriorityQueue;
    final LinkedBlockingQueue<XNetListener> highPriorityListeners;
    final LenzCommandStation mCommandStation;
    XNetSystemConnectionMemo mMemo = null;
    private XNetFeedbackMessageCache _FeedbackCache = null;
    private static final Logger log = LoggerFactory.getLogger(XNetTrafficController.class);

    XNetTrafficController(LenzCommandStation pCommandStation) {
        this.mCommandStation = pCommandStation;
        this.setAllowUnexpectedReply(true);
        this.mListenerMasks = new HashMap();
        this.highPriorityQueue = new LinkedBlockingQueue();
        this.highPriorityListeners = new LinkedBlockingQueue();
    }

    @Override
    public void connectPort(AbstractPortController p) {
        super.connectPort(p);
        if (p instanceof XNetPortController) {
            this.addXNetListener(1, new XNetTimeSlotListener((XNetPortController)((Object)p)));
        }
    }

    @Override
    public void forwardMessage(AbstractMRListener reply, AbstractMRMessage m) {
        if (!(reply instanceof XNetListener) || !(m instanceof XNetMessage)) {
            throw new IllegalArgumentException("");
        }
        ((XNetListener)reply).message((XNetMessage)m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        if (!(client instanceof XNetListener) || !(m instanceof XNetReply)) {
            throw new IllegalArgumentException("");
        }
        if (!((XNetReply)m).checkParity()) {
            log.warn("Ignore packet with bad checksum: {}", (Object)m);
        } else {
            int mask;
            XNetTrafficController xNetTrafficController = this;
            synchronized (xNetTrafficController) {
                mask = this.mListenerMasks.getOrDefault(client, -1);
            }
            if (mask == -1) {
                ((XNetListener)client).message((XNetReply)m);
            } else if ((mask & 1) == 1 && m.getElement(0) == 1) {
                ((XNetListener)client).message((XNetReply)m);
            } else if ((mask & 2) == 2 && (m.getElement(0) == 97 || m.getElement(0) == 99 || m.getElement(0) == 98 || m.getElement(0) == 129)) {
                ((XNetListener)client).message((XNetReply)m);
            } else if ((mask & 8) == 8 && (((XNetReply)m).isFeedbackMessage() || ((XNetReply)m).isFeedbackBroadcastMessage())) {
                ((XNetListener)client).message((XNetReply)m);
            } else if ((mask & 0x10) == 16 && ((XNetReply)m).isThrottleMessage()) {
                ((XNetListener)client).message((XNetReply)m);
            } else if ((mask & 0x20) == 32 && ((XNetReply)m).isConsistMessage()) {
                ((XNetListener)client).message((XNetReply)m);
            } else if ((mask & 0x40) == 64 && (m.getElement(0) == 2 || m.getElement(0) == 242)) {
                ((XNetListener)client).message((XNetReply)m);
            }
        }
    }

    public synchronized void sendHighPriorityXNetMessage(XNetMessage m, XNetListener reply) {
        this.highPriorityListeners.add(reply);
        this.highPriorityQueue.add(m);
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        try {
            if (this.highPriorityQueue.peek() == null) {
                return null;
            }
            return this.highPriorityQueue.take();
        }
        catch (InterruptedException ie) {
            log.error("Interrupted while removing High Priority Message from Queue");
            return null;
        }
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        try {
            if (this.highPriorityListeners.peek() == null) {
                return null;
            }
            return this.highPriorityListeners.take();
        }
        catch (InterruptedException ie) {
            log.error("Interrupted while removing High Priority Message Listener from Queue");
            return null;
        }
    }

    @Override
    public synchronized void addXNetListener(int mask, XNetListener l) {
        this.addListener(l);
        this.mListenerMasks.put(l, mask);
    }

    @Override
    public synchronized void removeXNetListener(int mask, XNetListener l) {
        this.removeListener(l);
        this.mListenerMasks.remove(l);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return XNetMessage.getExitProgModeMsg();
    }

    @Override
    protected boolean programmerIdle() {
        if (this.mMemo == null) {
            return true;
        }
        XNetProgrammerManager pm = this.mMemo.getProgrammerManager();
        if (pm == null) {
            return true;
        }
        XNetProgrammer p = (XNetProgrammer)pm.getGlobalProgrammer();
        if (p == null) {
            return true;
        }
        return !p.programmerBusy();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        int len = (msg.getElement(0) & 0xF) + 2;
        log.debug("Message Length {} Current Size {}", (Object)len, (Object)msg.getNumDataElements());
        return msg.getNumDataElements() >= len;
    }

    @Override
    protected AbstractMRReply newReply() {
        return new XNetReply();
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        for (int i = 0; i < msg.maxSize(); ++i) {
            byte char1 = this.readByteProtected(istream);
            msg.setElement(i, char1 & 0xFF);
            if (this.endOfMessage(msg)) break;
        }
        if (this.mCurrentState == 10) {
            msg.setUnsolicited();
        }
    }

    @Override
    protected void handleTimeout(AbstractMRMessage msg, AbstractMRListener l) {
        super.handleTimeout(msg, l);
        if (l != null) {
            ((XNetListener)l).notifyTimeout((XNetMessage)msg);
        }
    }

    @Override
    protected void notifyMessage(AbstractMRMessage m, AbstractMRListener notMe) {
        super.notifyMessage(m, notMe);
        if (notMe != null) {
            this.forwardMessage(notMe, m);
        }
    }

    public LenzCommandStation getCommandStation() {
        return this.mCommandStation;
    }

    public XNetSystemConnectionMemo getSystemConnectionMemo() {
        return this.mMemo;
    }

    public void setSystemConnectionMemo(XNetSystemConnectionMemo m) {
        this.mMemo = m;
    }

    public XNetFeedbackMessageCache getFeedbackMessageCache() {
        if (this._FeedbackCache == null) {
            this._FeedbackCache = new XNetFeedbackMessageCache(this);
        }
        return this._FeedbackCache;
    }

    boolean hasTimeSlot() {
        return ((XNetPortController)((Object)this.controller)).hasTimeSlot();
    }
}

