/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetInterface;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetTrafficRouter
extends XNetTrafficController
implements XNetListener {
    boolean connected = false;
    XNetListener lastSender = null;
    private XNetInterface destination = null;
    private static final Logger log = LoggerFactory.getLogger(XNetTrafficRouter.class);

    public XNetTrafficRouter(LenzCommandStation pCommandStation) {
        super(pCommandStation);
    }

    @Override
    public boolean status() {
        return this.connected;
    }

    @Override
    public void sendXNetMessage(XNetMessage m, XNetListener replyTo) {
        this.lastSender = replyTo;
        this.destination.sendXNetMessage(m, replyTo);
    }

    @Override
    public void message(XNetReply m) {
        this.notify(m);
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message{}", (Object)msg.toString());
        }
    }

    public void connect(XNetInterface i) {
        this.destination = i;
        this.connected = true;
        i.addXNetListener(-1, this);
    }

    public void disconnectPort(XNetInterface i) {
        if (this.destination != i) {
            log.warn("disconnectPort: disconnect called from non-connected PortController");
        }
        this.destination = null;
        this.connected = false;
    }

    protected void notify(XNetReply m) {
        this.notifyReply(m, this.lastSender);
        this.lastSender = null;
    }
}

