/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.hornbyelite;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.lenz.XNetInitializationManager;
import jmri.jmrix.lenz.XNetLightManager;
import jmri.jmrix.lenz.XNetPacketizer;
import jmri.jmrix.lenz.XNetPowerManager;
import jmri.jmrix.lenz.XNetProgrammerManager;
import jmri.jmrix.lenz.XNetSerialPortController;
import jmri.jmrix.lenz.hornbyelite.Bundle;
import jmri.jmrix.lenz.hornbyelite.EliteXNetProgrammer;
import jmri.jmrix.lenz.hornbyelite.EliteXNetSystemConnectionMemo;
import jmri.jmrix.lenz.hornbyelite.EliteXNetThrottleManager;
import jmri.jmrix.lenz.hornbyelite.EliteXNetTurnoutManager;
import jmri.jmrix.lenz.hornbyelite.HornbyEliteCommandStation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EliteAdapter
extends XNetSerialPortController {
    protected final String[] validSpeeds = new String[]{Bundle.getMessage("Baud9600"), Bundle.getMessage("Baud19200"), Bundle.getMessage("Baud38400"), Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200")};
    protected final int[] validSpeedValues = new int[]{9600, 19200, 38400, 57600, 115200};
    protected final String[] validOption1 = new String[]{Bundle.getMessage("FlowOptionNo"), Bundle.getMessage("FlowOptionHw")};
    private static final Logger log = LoggerFactory.getLogger(EliteAdapter.class);

    public EliteAdapter() {
        super(new EliteXNetSystemConnectionMemo());
        this.option1Name = "FlowControl";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("HornbyEliteConnectionLabel"), this.validOption1));
        this.manufacturerName = "Hornby";
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect Elite Adapter to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting Elite Adapter to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        AbstractSerialPortController.FlowControl flow = AbstractSerialPortController.FlowControl.NONE;
        if (!this.getOptionState(this.option1Name).equals(this.validOption1[0])) {
            flow = AbstractSerialPortController.FlowControl.RTSCTS;
        }
        this.setFlowControl(this.currentSerialPort, flow);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        XNetPacketizer packets = new XNetPacketizer(new HornbyEliteCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setXNetTrafficController(packets);
        new XNetInitializationManager().memo(this.getSystemConnectionMemo()).powerManager(XNetPowerManager.class).throttleManager(EliteXNetThrottleManager.class).programmer(EliteXNetProgrammer.class).programmerManager(XNetProgrammerManager.class).turnoutManager(EliteXNetTurnoutManager.class).lightManager(XNetLightManager.class).init();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

