/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.hornbyelite;

import jmri.LocoAddress;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetThrottle;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EliteXNetThrottle
extends XNetThrottle {
    protected static final int statTimeoutValue = 5000;
    private static final String MOMENTARY_FUNCTION_REQUEST_NOT_SUPPORTED_BY_ELITE = "Momentary function request not supported by Elite.";
    private static final Logger log = LoggerFactory.getLogger(EliteXNetThrottle.class);

    public EliteXNetThrottle(XNetSystemConnectionMemo memo, XNetTrafficController tc) {
        super(memo, tc);
        log.debug("Elite XNetThrottle constructor");
    }

    public EliteXNetThrottle(XNetSystemConnectionMemo memo, LocoAddress address, XNetTrafficController tc) {
        super(memo, address, tc);
        log.debug("Elite XNetThrottle constructor called for address {}", (Object)address);
    }

    @Override
    protected void sendMomentaryFunctionGroup1() {
        log.debug(MOMENTARY_FUNCTION_REQUEST_NOT_SUPPORTED_BY_ELITE);
    }

    @Override
    protected void sendMomentaryFunctionGroup2() {
        log.debug(MOMENTARY_FUNCTION_REQUEST_NOT_SUPPORTED_BY_ELITE);
    }

    @Override
    protected void sendMomentaryFunctionGroup3() {
        log.debug(MOMENTARY_FUNCTION_REQUEST_NOT_SUPPORTED_BY_ELITE);
    }

    @Override
    protected void sendMomentaryFunctionGroup4() {
        log.debug(MOMENTARY_FUNCTION_REQUEST_NOT_SUPPORTED_BY_ELITE);
    }

    @Override
    protected void sendMomentaryFunctionGroup5() {
        log.debug(MOMENTARY_FUNCTION_REQUEST_NOT_SUPPORTED_BY_ELITE);
    }

    @Override
    protected synchronized void sendFunctionStatusInformationRequest() {
        log.debug(MOMENTARY_FUNCTION_REQUEST_NOT_SUPPORTED_BY_ELITE);
    }

    @Override
    public void message(XNetReply l) {
        log.debug("Throttle - received message ");
        if (this.requestState == 0) {
            log.debug("Current throttle status is THROTTLEIDLE");
            if (l.getElement(0) == 229) {
                log.debug("Throttle - message is LOCO_INFO_RESPONSE ");
                if (l.getElement(1) == 248) {
                    if (this.getDccAddressHigh() == l.getElement(2) && this.getDccAddressLow() == l.getElement(3)) {
                        log.info("Loco {} in use by another device", (Object)this.getDccAddress());
                        this.setIsAvailable(false);
                        this.parseSpeedAndAvailability(l.getElement(4));
                        this.parseSpeedAndDirection(l.getElement(5));
                    }
                } else if (l.getElement(1) == 249 && this.getDccAddressHigh() == l.getElement(2) && this.getDccAddressLow() == l.getElement(3)) {
                    log.info("Loco {} in use by another device", (Object)this.getDccAddress());
                    this.setIsAvailable(false);
                    this.parseFunctionInformation(l.getElement(4), l.getElement(5));
                }
            }
        }
        super.message(l);
    }

    @Override
    protected void startStatusTimer() {
    }

    @Override
    protected void stopStatusTimer() {
    }
}

