/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.hornbyelite;

import javax.annotation.Nonnull;
import jmri.Turnout;
import jmri.jmrix.lenz.XNetAddress;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTurnoutManager;
import jmri.jmrix.lenz.hornbyelite.EliteXNetTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EliteXNetTurnoutManager
extends XNetTurnoutManager {
    private static final Logger log = LoggerFactory.getLogger(EliteXNetTurnoutManager.class);

    public EliteXNetTurnoutManager(XNetSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int bitNum = XNetAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
        if (bitNum == -1) {
            throw new IllegalArgumentException("Cannot get Bit from System Name " + systemName);
        }
        EliteXNetTurnout t = new EliteXNetTurnout(this.getSystemPrefix(), bitNum, this.tc);
        t.setUserName(userName);
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public void message(XNetReply l) {
        log.debug("received message: {}", (Object)l);
        if (l.isFeedbackBroadcastMessage()) {
            int numDataBytes = l.getElement(0) & 0xF;
            for (int i = 1; i < numDataBytes; i += 2) {
                int a2;
                int addr = l.getTurnoutMsgAddr(i);
                if (addr < 0) continue;
                log.debug("message has address: {}", (Object)addr);
                String s = this.getSystemNamePrefix() + (addr - 1);
                this.forwardMessageToTurnout(s, l);
                if ((addr & 1) != 1 || ((a2 = l.getElement(i + 1)) & 0xC) == 0) continue;
                s = this.getSystemNamePrefix() + addr;
                this.forwardMessageToTurnout(s, l);
            }
        }
    }
}

