/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.li100;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetInitializationManager;
import jmri.jmrix.lenz.XNetSerialPortController;
import jmri.jmrix.lenz.li100.Bundle;
import jmri.jmrix.lenz.li100.LI100XNetPacketizer;
import jmri.jmrix.lenz.li100.LI100XNetProgrammer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LI100Adapter
extends XNetSerialPortController {
    protected final String[] validSpeeds = new String[]{Bundle.getMessage("Baud9600")};
    protected final int[] validSpeedValues = new int[]{9600};
    protected final String[] validOption1 = new String[]{Bundle.getMessage("FlowOptionHwRecomm"), Bundle.getMessage("FlowOptionNo")};
    private static final Logger log = LoggerFactory.getLogger(LI100Adapter.class);

    public LI100Adapter() {
        this.option1Name = "FlowControl";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("XconnectionUsesLabel", Bundle.getMessage("IFTypeLI100")), this.validOption1));
        this.manufacturerName = "Lenz";
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect LI100 to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting LI100 to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        AbstractSerialPortController.FlowControl flow = AbstractSerialPortController.FlowControl.RTSCTS;
        if (!this.getOptionState(this.option1Name).equals(this.validOption1[0])) {
            flow = AbstractSerialPortController.FlowControl.NONE;
        }
        this.setFlowControl(this.currentSerialPort, flow);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        LI100XNetPacketizer packets = new LI100XNetPacketizer(new LenzCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setXNetTrafficController(packets);
        new XNetInitializationManager().memo(this.getSystemConnectionMemo()).setDefaults().versionCheck().setTimeout(30000).programmer(LI100XNetProgrammer.class).init();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

