/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.li100f;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetInitializationManager;
import jmri.jmrix.lenz.XNetPacketizer;
import jmri.jmrix.lenz.XNetSerialPortController;
import jmri.jmrix.lenz.li100f.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LI100fAdapter
extends XNetSerialPortController {
    protected final String[] validSpeeds = new String[]{Bundle.getMessage("Baud9600"), Bundle.getMessage("LIBaud19200")};
    protected final int[] validSpeedValues = new int[]{9600, 19200};
    protected final String[] validOption1 = new String[]{Bundle.getMessage("FlowOptionHwRecomm"), Bundle.getMessage("FlowOptionNo")};
    private static final Logger log = LoggerFactory.getLogger(LI100fAdapter.class);

    public LI100fAdapter() {
        this.option1Name = "FlowControl";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("XconnectionUsesLabel", Bundle.getMessage("IFTypeLI100F")), this.validOption1));
        this.manufacturerName = "Lenz";
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect LI100F to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting LI100F to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        AbstractSerialPortController.FlowControl flow = AbstractSerialPortController.FlowControl.RTSCTS;
        if (!this.getOptionState(this.option1Name).equals(this.validOption1[0])) {
            flow = AbstractSerialPortController.FlowControl.NONE;
        }
        this.setFlowControl(this.currentSerialPort, flow);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        XNetPacketizer packets = new XNetPacketizer(new LenzCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setXNetTrafficController(packets);
        new XNetInitializationManager().memo(this.getSystemConnectionMemo()).setDefaults().versionCheck().setTimeout(30000).init();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    public String option1Name() {
        return Bundle.getMessage("XconnectionUsesLabel", Bundle.getMessage("IFTypeLI100F"));
    }

    public String[] validOption1() {
        return Arrays.copyOf(this.validOption1, this.validOption1.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

