/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.liusb;

import java.io.DataInputStream;
import java.io.IOException;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetPacketizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIUSBXNetPacketizer
extends XNetPacketizer {
    private static final Logger log = LoggerFactory.getLogger(LIUSBXNetPacketizer.class);

    public LIUSBXNetPacketizer(LenzCommandStation pCommandStation) {
        super(pCommandStation);
        log.debug("Loading LIUSB Extention to XNetPacketizer");
    }

    @Override
    protected int addHeaderToOutput(byte[] msg, AbstractMRMessage m) {
        log.debug("Appending 0xFF 0xFE to start of outgoing message");
        msg[0] = -1;
        msg[1] = -2;
        return 2;
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        return m.getNumDataElements() + 2;
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        int lastbyte = -1;
        log.debug("loading characters from port");
        for (int i = 0; i < msg.maxSize(); ++i) {
            byte char1 = this.readByteProtected(istream);
            while (i == 0 && (char1 & 0xF0) == 240) {
                if ((char1 & 0xFF) == 240 || (char1 & 0xFF) == 242) continue;
                lastbyte = char1;
                char1 = this.readByteProtected(istream);
            }
            if (lastbyte == -3) {
                msg.setUnsolicited();
            }
            msg.setElement(i, char1 & 0xFF);
            if (this.endOfMessage(msg)) break;
        }
    }
}

