/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.liusbethernet;

import java.io.IOException;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetHeartBeat;
import jmri.jmrix.lenz.XNetInitializationManager;
import jmri.jmrix.lenz.XNetNetworkPortController;
import jmri.jmrix.lenz.liusbethernet.Bundle;
import jmri.jmrix.lenz.liusbethernet.LIUSBEthernetXNetPacketizer;
import jmri.util.zeroconf.ZeroConfClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIUSBEthernetAdapter
extends XNetNetworkPortController {
    static final int COMMUNICATION_TCP_PORT = 5550;
    static final String DEFAULT_IP_ADDRESS = "192.168.0.200";
    private boolean mDNSConfigure = false;
    ZeroConfClient mdnsClient = null;
    private static final Logger log = LoggerFactory.getLogger(LIUSBEthernetAdapter.class);

    public LIUSBEthernetAdapter() {
        log.debug("Constructor Called");
        this.setHostName(DEFAULT_IP_ADDRESS);
        this.setPort(5550);
        this.manufacturerName = "Lenz";
    }

    @Override
    public void connect() throws IOException {
        super.connect();
        log.debug("openPort called");
    }

    @Override
    public boolean okToSend() {
        return this.status() && super.okToSend();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public void configure() {
        log.debug("configure called");
        LIUSBEthernetXNetPacketizer packets = new LIUSBEthernetXNetPacketizer(new LenzCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setXNetTrafficController(packets);
        new XNetInitializationManager().memo(this.getSystemConnectionMemo()).setDefaults().versionCheck().setTimeout(30000).init();
        new XNetHeartBeat(this.getSystemConnectionMemo());
    }

    @Override
    public void setMdnsConfigure(boolean autoconfig) {
        log.debug("Setting LIUSB Ethernet adapter autoconfiguration to: {}", (Object)autoconfig);
        this.mDNSConfigure = autoconfig;
    }

    @Override
    public boolean getMdnsConfigure() {
        return this.mDNSConfigure;
    }

    @Override
    public void autoConfigure() {
        log.info("Configuring XpressNet interface via JmDNS");
        if (this.getHostName().equals(DEFAULT_IP_ADDRESS)) {
            this.setHostName("");
        }
        String serviceType = Bundle.getMessage("defaultMDNSServiceType");
        log.debug("Listening for service: {}", (Object)serviceType);
        if (this.mdnsClient == null) {
            this.mdnsClient = new ZeroConfClient();
            this.mdnsClient.startServiceListener(serviceType);
        }
        try {
            String qualifiedHostName = this.m_HostName + "." + Bundle.getMessage("defaultMDNSDomainName");
            this.setHostAddress(this.mdnsClient.getServiceOnHost(serviceType, qualifiedHostName).getHostAddresses()[0]);
        }
        catch (NullPointerException npe) {
            String qualifiedServiceName = Bundle.getMessage("defaultMDNSServiceName") + "." + serviceType;
            this.setHostAddress(this.mdnsClient.getServicebyAdName(serviceType, qualifiedServiceName).getHostAddresses()[0]);
        }
    }

    @Override
    public String getAdvertisementName() {
        return Bundle.getMessage("defaultMDNSServiceName");
    }

    @Override
    public String getServiceType() {
        return Bundle.getMessage("defaultMDNSServiceType");
    }
}

