/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.liusbserver;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetPacketizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIUSBServerXNetPacketizer
extends XNetPacketizer {
    private static final Logger log = LoggerFactory.getLogger(LIUSBServerXNetPacketizer.class);

    public LIUSBServerXNetPacketizer(LenzCommandStation pCommandStation) {
        super(pCommandStation);
        log.debug("Loading LIUSB Server Extension to XNetPacketizer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="Wait is for external hardware, which doesn't necessarilly respond, to process the data.")
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        block12: {
            log.debug("forwardToPort message: [{}]", (Object)m);
            this.mLastSender = reply;
            AbstractMRTrafficController.XmtNotifier r = new AbstractMRTrafficController.XmtNotifier(m, this.mLastSender, this);
            SwingUtilities.invokeLater(r);
            try {
                if (this.ostream != null) {
                    while (m.getRetries() >= 0) {
                        if (this.portReadyToSend(this.controller)) {
                            this.ostream.write((m + "\n\r").getBytes(StandardCharsets.UTF_8));
                            this.ostream.flush();
                            log.debug("written");
                            break block12;
                        }
                        if (m.getRetries() >= 0) {
                            if (log.isDebugEnabled()) {
                                log.debug("Retry message: {} attempts remaining: {}", (Object)m.toString(), (Object)m.getRetries());
                            }
                            m.setRetries(m.getRetries() - 1);
                            try {
                                Runnable runnable = this.xmtRunnable;
                                synchronized (runnable) {
                                    this.xmtRunnable.wait(m.getTimeout());
                                    continue;
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                log.error("retry wait interrupted");
                                continue;
                            }
                        }
                        log.warn("sendMessage: port not ready for data sending: {}", (Object)m.toString());
                    }
                    break block12;
                }
                this.connectionWarn();
            }
            catch (IOException e) {
                this.portWarn(e);
                this.controller.recover();
            }
        }
    }
}

