/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.messageformatters;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.Message;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.messageformatters.Bundle;

public class XNetCSSoftwareVersionReplyFormatter
implements XPressNetMessageFormatter {
    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof XNetReply && ((XNetReply)m).getElement(0) == 99 && ((XNetReply)m).getElement(1) == 33;
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="cast is checked in handlesMessage")
    public String formatMessage(Message m) {
        Object typeString;
        if (!this.handlesMessage(m)) {
            throw new IllegalArgumentException("Message is not a V3 CS Software Version Reply");
        }
        XNetReply r = (XNetReply)m;
        switch (r.getElement(3)) {
            case 0: {
                typeString = Bundle.getMessage("CSTypeLZ100");
                break;
            }
            case 1: {
                typeString = Bundle.getMessage("CSTypeLH200");
                break;
            }
            case 2: {
                typeString = Bundle.getMessage("CSTypeCompact");
                break;
            }
            case 16: {
                typeString = Bundle.getMessage("CSTypeMultiMaus");
                break;
            }
            default: {
                typeString = "" + r.getElement(3);
            }
        }
        return Bundle.getMessage("XNetReplyCSVersion", Float.valueOf(r.getElementBCD(2).floatValue() / 10.0f), typeString);
    }
}

