/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.messageformatters;

import jmri.jmrix.Message;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.messageformatters.Bundle;

public class XNetCSStatusReplyFormatter
implements XPressNetMessageFormatter {
    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof XNetReply && m.getElement(0) == 98 && m.getElement(1) == 34;
    }

    @Override
    public String formatMessage(Message m) {
        if (!this.handlesMessage(m)) {
            throw new IllegalArgumentException("Message is not supported");
        }
        StringBuilder text = new StringBuilder(Bundle.getMessage("XNetReplyCSStatus") + " ");
        int statusByte = m.getElement(2);
        if ((statusByte & 1) == 1) {
            text.append(Bundle.getMessage("XNetCSStatusEmergencyOff")).append("; ");
        }
        if ((statusByte & 2) == 2) {
            text.append(Bundle.getMessage("XNetCSStatusEmergencyStop")).append("; ");
        }
        if ((statusByte & 8) == 8) {
            text.append(Bundle.getMessage("XNetCSStatusServiceMode")).append("; ");
        }
        if ((statusByte & 0x40) == 64) {
            text.append(Bundle.getMessage("XNetCSStatusPoweringUp")).append("; ");
        }
        if ((statusByte & 4) == 4) {
            text.append(Bundle.getMessage("XNetCSStatusPowerModeAuto")).append("; ");
        } else {
            text.append(Bundle.getMessage("XNetCSStatusPowerModeManual")).append("; ");
        }
        if ((statusByte & 0x80) == 128) {
            text.append(Bundle.getMessage("XNetCSStatusRamCheck"));
        }
        return text.toString();
    }
}

