/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.messageformatters;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.Message;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.messageformatters.Bundle;

public class XNetFunctionGroup10OperateRequestMessageFormatter
implements XPressNetMessageFormatter {
    private static final String X_NET_MESSAGE_SET_FUNCTION_GROUP_X = "XNetMessageSetFunctionGroupX";
    private static final String POWER_STATE_ON = "PowerStateOn";
    private static final String POWER_STATE_OFF = "PowerStateOff";

    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof XNetMessage && m.getElement(0) == 228 && m.getElement(1) == 81;
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="cast is checked in handlesMessage")
    public String formatMessage(Message m) {
        if (!this.handlesMessage(m)) {
            throw new IllegalArgumentException("XNetFunction10OperateRequestMessageFormatter: message type not supported");
        }
        return "Mobile Decoder Operations Request: " + this.buildSetFunctionGroup10MonitorString((XNetMessage)m);
    }

    private String buildSetFunctionGroup10MonitorString(XNetMessage m) {
        String text = Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X, 10) + " " + LenzCommandStation.calcLocoAddress(m.getElement(2), m.getElement(3)) + " ";
        int element4 = m.getElement(4);
        text = (element4 & 1) != 0 ? text + "F61 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F61 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 2) != 0 ? text + "F62 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F62 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 4) != 0 ? text + "F63 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F63 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 8) != 0 ? text + "F64 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F64 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x10) != 0 ? text + "F65 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F65 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x20) != 0 ? text + "F66 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F66 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x40) != 0 ? text + "F67 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F67 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x80) != 0 ? text + "F68 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F68 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        return text;
    }
}

