/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.messageformatters;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.Message;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.messageformatters.Bundle;

public class XNetFunctionGroup5OperateRequestMessageFormatter
implements XPressNetMessageFormatter {
    private static final String X_NET_MESSAGE_SET_FUNCTION_GROUP_X = "XNetMessageSetFunctionGroupX";
    private static final String POWER_STATE_ON = "PowerStateOn";
    private static final String POWER_STATE_OFF = "PowerStateOff";

    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof XNetMessage && m.getElement(0) == 228 && m.getElement(1) == 40;
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="cast is checked in handlesMessage")
    public String formatMessage(Message m) {
        if (!this.handlesMessage(m)) {
            throw new IllegalArgumentException("XNetFunction4OperateRequestMessageFormatter: message type not supported");
        }
        return "Mobile Decoder Operations Request: " + this.buildSetFunctionGroup5MonitorString((XNetMessage)m);
    }

    private String buildSetFunctionGroup5MonitorString(XNetMessage m) {
        String text = Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X, 5) + " " + LenzCommandStation.calcLocoAddress(m.getElement(2), m.getElement(3)) + " ";
        int element4 = m.getElement(4);
        text = (element4 & 1) != 0 ? text + "F21 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F21 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 2) != 0 ? text + "F22 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F22 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 4) != 0 ? text + "F23 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F23 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 8) != 0 ? text + "F24 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F24 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x10) != 0 ? text + "F25 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F25 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x20) != 0 ? text + "F26 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F26 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x40) != 0 ? text + "F27 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F27 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x80) != 0 ? text + "F28 " + Bundle.getMessage(POWER_STATE_ON) + "; " : text + "F28 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        return text;
    }
}

