/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.messageformatters;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.Message;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.messageformatters.Bundle;

public class XNetFunctionGroup9MomentaryRequestMessageFormatter
implements XPressNetMessageFormatter {
    private static final String X_NET_MESSAGE_SET_FUNCTION_GROUP_X_MOMENTARY = "XNetMessageSetFunctionGroupXMomentary";
    private static final String FUNCTION_CONTINUOUS = "FunctionContinuous";
    private static final String FUNCTION_MOMENTARY = "FunctionMomentary";

    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof XNetMessage && m.getElement(0) == 228 && m.getElement(1) == 83;
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="cast is checked in handlesMessage")
    public String formatMessage(Message m) {
        if (!this.handlesMessage(m)) {
            throw new IllegalArgumentException("XNetFunction10MomentaryRequestMessageFormatter: message type not supported");
        }
        return "Mobile Decoder Operations Request: " + this.buildSetFunctionGroup9MomentaryMonitorString((XNetMessage)m);
    }

    private String buildSetFunctionGroup9MomentaryMonitorString(XNetMessage m) {
        String text = Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X_MOMENTARY, 9) + " " + LenzCommandStation.calcLocoAddress(m.getElement(2), m.getElement(3)) + " ";
        int element4 = m.getElement(4);
        text = (element4 & 1) == 0 ? text + "F53 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : text + "F53 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 2) == 0 ? text + "F54 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : text + "F54 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 4) == 0 ? text + "F55 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : text + "F55 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 8) == 0 ? text + "F56 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : text + "F56 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x10) == 0 ? text + "F57 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : text + "F57 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x20) == 0 ? text + "F58 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : text + "F58 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x40) == 0 ? text + "F59 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : text + "F59 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x80) == 0 ? text + "F60 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : text + "F60 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        return text;
    }
}

