/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.messageformatters;

import jmri.jmrix.Message;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.messageformatters.Bundle;

public class XNetLI101RequestMessageFormatter
implements XPressNetMessageFormatter {
    private static final String X_NET_MESSAGE_REQUEST_LI_BAUD = "XNetMessageRequestLIBaud";

    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof XNetMessage && ((XNetMessage)m).getElement(0) == 242;
    }

    @Override
    public String formatMessage(Message m) {
        if (m.getElement(1) == 1) {
            return Bundle.getMessage("XNetMessageRequestLIAddress", m.getElement(2));
        }
        if (m.getElement(1) == 2) {
            switch (m.getElement(2)) {
                case 1: {
                    return Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("LIBaud19200"));
                }
                case 2: {
                    return Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("Baud38400"));
                }
                case 3: {
                    return Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("Baud57600"));
                }
                case 4: {
                    return Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("Baud115200"));
                }
            }
            return Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("BaudOther"));
        }
        throw new IllegalArgumentException("Unknown LI101 Request Type");
    }
}

