/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.messageformatters;

import jmri.jmrix.Message;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.messageformatters.Bundle;

public class XNetOpsModeRequestMessageFormatter
implements XPressNetMessageFormatter {
    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof XNetMessage && m.getElement(0) == 230;
    }

    @Override
    public String formatMessage(Message m) {
        if (m.getElement(1) == 48) {
            if ((m.getElement(4) & 0xEC) == 236 || (m.getElement(4) & 0xE4) == 228) {
                return XNetOpsModeRequestMessageFormatter.getWriteString(m);
            }
            if ((m.getElement(4) & 0xE8) == 232) {
                return XNetOpsModeRequestMessageFormatter.getVerifyString(m);
            }
        }
        throw new IllegalArgumentException("Unknown Ops Mode Request Type");
    }

    private static String getVerifyString(Message m) {
        String message = (m.getElement(6) & 0x10) == 16 ? "XNetMessageOpsModeBitVerify" : "XNetMessageOpsModeBitWrite";
        return Bundle.getMessage(message, (m.getElement(6) & 8) >> 3, 1 + m.getElement(5) + ((m.getElement(4) & 3) << 8), m.getElement(6) & 7, LenzCommandStation.calcLocoAddress(m.getElement(2), m.getElement(3)));
    }

    private static String getWriteString(Message m) {
        String message = "";
        if ((m.getElement(4) & 0xEC) == 236) {
            message = "XNetMessageOpsModeByteWrite";
        } else if ((m.getElement(4) & 0xE4) == 228) {
            message = "XNetMessageOpsModeByteVerify";
        }
        return Bundle.getMessage(message, m.getElement(6), 1 + m.getElement(5) + ((m.getElement(4) & 3) << 8), LenzCommandStation.calcLocoAddress(m.getElement(2), m.getElement(3)));
    }
}

