/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.messageformatters;

import jmri.jmrix.Message;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.messageformatters.Bundle;

public class XNetProgReadMessageFormatter
implements XPressNetMessageFormatter {
    private static final String X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36 = "XNetMessageRequestServiceModeReadDirectV36";

    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof XNetMessage && m.getElement(0) == 34 && (m.getElement(1) == 17 || m.getElement(1) == 21 || m.getElement(1) == 20 || m.getElement(1) >= 24 && m.getElement(1) <= 27);
    }

    @Override
    public String formatMessage(Message m) {
        switch (m.getElement(1)) {
            case 17: {
                return Bundle.getMessage("XNetMessageRequestServiceModeReadRegister", m.getElement(2));
            }
            case 21: {
                return Bundle.getMessage("XNetMessageRequestServiceModeReadDirect", m.getElement(2));
            }
            case 20: {
                return Bundle.getMessage("XNetMessageRequestServiceModeReadPaged", m.getElement(2));
            }
            case 24: {
                return Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36, m.getElement(2) == 0 ? 1024 : m.getElement(2));
            }
            case 25: {
                return Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36, 256 + m.getElement(2));
            }
            case 26: {
                return Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36, 512 + m.getElement(2));
            }
            case 27: {
                return Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36, 768 + m.getElement(2));
            }
        }
        throw new IllegalArgumentException("Unknown Programming Read Message");
    }
}

