/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.swing.li101;

import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.swing.li101.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LI101Frame
extends JmriJFrame
implements XNetListener {
    protected XNetTrafficController tc;
    boolean read = false;
    final JComboBox<String> addrBox = new JComboBox();
    final JComboBox<String> speedBox = new JComboBox();
    final JLabel status = new JLabel("");
    final JToggleButton readSettingsButton = new JToggleButton(Bundle.getMessage("LI101ReadButton"));
    final JToggleButton writeSettingsButton = new JToggleButton(Bundle.getMessage("LI101WriteButton"));
    final JButton closeButton = new JButton(Bundle.getMessage("ButtonClose"));
    final JButton resetButton = new JButton(Bundle.getMessage("ButtonResetDefaults"));
    protected final String[] validXNetAddresses = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", ""};
    protected final String[] validSpeeds = new String[]{Bundle.getMessage("LIBaud19200"), Bundle.getMessage("Baud38400"), Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200"), ""};
    protected int[] validSpeedValues = new int[]{19200, 38400, 57600, 115200};
    private static final Logger log = LoggerFactory.getLogger(LI101Frame.class);

    public LI101Frame(XNetSystemConnectionMemo memo) {
        super(Bundle.getMessage("MenuItemLI101ConfigurationManager"));
        this.tc = memo.getXNetTrafficController();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pane0 = new JPanel();
        pane0.setLayout(new FlowLayout());
        pane0.add(new JLabel(Bundle.getMessage("XNetAddressLabel")));
        pane0.add(this.addrBox);
        pane0.setAlignmentX(0.5f);
        this.getContentPane().add(pane0);
        JPanel pane1 = new JPanel();
        pane1.add(new JLabel(Bundle.getMessage("LI101SpeedSettingLabel")));
        pane1.add(this.speedBox);
        pane1.setAlignmentX(0.5f);
        this.getContentPane().add(pane1);
        JPanel pane2 = new JPanel();
        pane2.add(this.readSettingsButton);
        pane2.add(this.writeSettingsButton);
        pane2.add(this.resetButton);
        this.resetButton.setToolTipText(Bundle.getMessage("ResetDefaultsToolTip"));
        pane2.add(this.closeButton);
        this.getContentPane().add(pane2);
        this.addrBox.setVisible(true);
        this.addrBox.setToolTipText(Bundle.getMessage("XNetAddressToolTip"));
        for (String validXNetAddress : this.validXNetAddresses) {
            this.addrBox.addItem(validXNetAddress);
        }
        this.addrBox.setSelectedIndex(32);
        this.speedBox.setVisible(true);
        this.speedBox.setToolTipText(Bundle.getMessage("LI101SpeedSettingToolTip"));
        for (String validSpeed : this.validSpeeds) {
            this.speedBox.addItem(validSpeed);
        }
        this.speedBox.setSelectedIndex(4);
        this.pack();
        this.status.setAlignmentX(0.5f);
        this.getContentPane().add(this.status);
        this.readSettingsButton.addActionListener(a -> this.readLI101Settings());
        this.writeSettingsButton.addActionListener(a -> this.writeLI101Settings());
        this.closeButton.addActionListener(a -> {
            this.setVisible(false);
            this.dispose();
        });
        this.resetButton.addActionListener(a -> this.resetLI101Settings());
        this.getContentPane().add(this.status);
        if (this.tc != null) {
            this.tc.addXNetListener(-1, this);
        } else {
            log.warn("No XpressNet connection, so panel won't function");
        }
    }

    void writeLI101Settings() {
        XNetMessage msg;
        if (!this.addrBox.getSelectedItem().equals("") && this.addrBox.getSelectedItem() != null) {
            msg = XNetMessage.getLIAddressRequestMsg(this.addrBox.getSelectedIndex());
            this.tc.sendXNetMessage(msg, this);
        }
        if (!this.speedBox.getSelectedItem().equals("") && this.speedBox.getSelectedItem() != null) {
            msg = XNetMessage.getLISpeedRequestMsg(this.speedBox.getSelectedIndex() + 1);
            this.tc.sendXNetMessage(msg, this);
        }
    }

    void readLI101Settings() {
        XNetMessage msg = XNetMessage.getLIAddressRequestMsg(32);
        this.tc.sendXNetMessage(msg, this);
        XNetMessage msg2 = XNetMessage.getLISpeedRequestMsg(6);
        this.tc.sendXNetMessage(msg2, this);
    }

    @Override
    public void message(XNetReply l) {
        if (l.getElement(0) == 242) {
            if (l.getElement(1) == 1) {
                this.addrBox.setSelectedIndex(l.getElement(2));
                this.status.setText("Address" + l.getElement(2) + "received from LI101");
            } else if (l.getElement(1) == 2) {
                this.speedBox.setSelectedIndex(l.getElement(2) - 1);
                this.status.setText("Baud rate" + this.validSpeeds[l.getElement(2) - 1] + "received from LI101");
            }
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message{}", (Object)msg.toString());
        }
    }

    void resetLI101Settings() {
        this.addrBox.setSelectedIndex(30);
        this.speedBox.setSelectedIndex(0);
    }
}

