/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.swing.lv102;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.InstanceManager;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrix.lenz.swing.lv102.Bundle;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LV102InternalFrame
extends JInternalFrame {
    private static final String LV_102_STATUS_CHANGED = "LV102StatusChanged";
    private static final String DEBUG_STATUS = "Current Status: {}";
    private static final String LV_102_STATUS_WRITE_RAIL_COM_MODE = "LV102StatusWriteRailComMode";
    private static final String LV_102_STATUS_PROG_MODE = "LV102StatusProgMode";
    private static final String LV_102_STATUS_WRITE_VOLT = "LV102StatusWriteVolt";
    private ProgReplyListener progListener;
    static final int WAIT_VALUE = 1000;
    boolean read = false;
    final JComboBox<String> voltBox = new JComboBox();
    final JComboBox<String> eLineBox = new JComboBox();
    final JComboBox<String> railComBox = new JComboBox();
    final JComboBox<String> railComModeBox = new JComboBox();
    final JComboBox<String> railComTimingBox = new JComboBox();
    final JLabel currentStatus = new JLabel(" ");
    final JToggleButton writeSettingsButton = new JToggleButton(Bundle.getMessage("LV102WriteSettingsButtonLabel"));
    final JButton defaultButton = new JButton(Bundle.getMessage("ButtonResetDefaults"));
    final JButton resetButton = new JButton(Bundle.getMessage("LV102ResetButtonLabel"));
    protected final String[] validVoltage = new String[]{"11V", "11.5V", "12V", "12.5V", "13V", "13.5V", "14V", "14.5V", "15V", "15.5V", Bundle.getMessage("Voltage16VDefault"), "16.5V", "17V", "17.5V", "18V", "18.5V", "19V", "19.5V", "20V", "20.5V", "21V", "21.5V", "22V", ""};
    protected final int[] validVoltageValues = new int[]{22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 0};
    protected final String[] validELineStatus = new String[]{Bundle.getMessage("LV102ELineActive"), Bundle.getMessage("LV102ELineInactive"), Bundle.getMessage("UseDefaultValue"), ""};
    protected final int[] validELineStatusValues = new int[]{90, 91, 99, 0};
    protected final String[] validRailComStatus = new String[]{Bundle.getMessage("LV102RailComActive"), Bundle.getMessage("LV102RailComInactive"), ""};
    protected final int[] validRailComStatusValues = new int[]{93, 92, 0};
    protected final String[] validRailComMode = new String[]{Bundle.getMessage("LV102RailCom3BitMode"), Bundle.getMessage("LV102RailCom4BitMode"), ""};
    protected final int[] validRailComModeValues = new int[]{94, 95, 0};
    protected final String[] validRailComTiming = new String[]{Bundle.getMessage("LV102RailComDefaultTiming"), Bundle.getMessage("LV102RailComNCETiming"), Bundle.getMessage("LV102RailComIncreaseTiming"), Bundle.getMessage("LV102RailComDecreaseTiming"), ""};
    protected final int[] validRailComTimingValues = new int[]{88, 89, 70, 71, 0};
    private static final Logger log = LoggerFactory.getLogger(LV102InternalFrame.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SC_START_IN_CTOR"}, justification="with existing code structure, we do not expect this to ever be subclassed.")
    public LV102InternalFrame() {
        this.progListener = new ProgReplyListener();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setTitle(Bundle.getMessage("LV102Power"));
        JPanel pane0 = new JPanel();
        pane0.setLayout(new FlowLayout());
        JLabel voltLabel = new JLabel(Bundle.getMessage("LV102Track"));
        pane0.add(voltLabel);
        voltLabel.setLabelFor(this.voltBox);
        pane0.add(this.voltBox);
        pane0.setAlignmentX(0.5f);
        this.getContentPane().add(pane0);
        JPanel pane1 = new JPanel();
        JLabel eLineLabel = new JLabel(Bundle.getMessage("LV102ELine"));
        pane1.add(eLineLabel);
        eLineLabel.setLabelFor(this.eLineBox);
        pane1.add(this.eLineBox);
        pane1.setAlignmentX(0.5f);
        this.getContentPane().add(pane1);
        JPanel pane2 = new JPanel();
        pane2.add(new JLabel(Bundle.getMessage("LV102RailCom")));
        pane2.add(this.railComBox);
        pane2.add(new JLabel(Bundle.getMessage("LV102RailComMode")));
        pane2.add(this.railComModeBox);
        pane2.add(new JLabel(Bundle.getMessage("LV102RailComTiming")));
        pane2.add(this.railComTimingBox);
        pane2.setAlignmentX(0.5f);
        this.getContentPane().add(pane2);
        JPanel pane3 = new JPanel();
        this.writeSettingsButton.setToolTipText(Bundle.getMessage("LV102WriteSettingsButtonToolTip"));
        pane3.add(this.writeSettingsButton);
        this.defaultButton.setToolTipText(Bundle.getMessage("ResetDefaultsToolTip"));
        this.resetButton.setToolTipText(Bundle.getMessage("LV102ResetButtonToolTip"));
        pane3.add(this.defaultButton);
        pane3.add(this.resetButton);
        this.getContentPane().add(pane3);
        this.voltBox.setVisible(true);
        this.voltBox.setToolTipText(Bundle.getMessage("LV102TrackTip"));
        for (String item : this.validVoltage) {
            this.voltBox.addItem(item);
        }
        this.voltBox.setSelectedIndex(23);
        this.eLineBox.setVisible(true);
        this.eLineBox.setToolTipText(Bundle.getMessage("LV102ELineTip"));
        for (String eLineStatus : this.validELineStatus) {
            this.eLineBox.addItem(eLineStatus);
        }
        this.eLineBox.setSelectedIndex(3);
        this.railComBox.setVisible(true);
        this.railComBox.setToolTipText(Bundle.getMessage("LV102RailComTip"));
        for (String railComStatus : this.validRailComStatus) {
            this.railComBox.addItem(railComStatus);
        }
        this.railComBox.setSelectedIndex(2);
        this.railComModeBox.setVisible(true);
        this.railComModeBox.setToolTipText(Bundle.getMessage("LV102RailComModeTip"));
        for (String value : this.validRailComMode) {
            this.railComModeBox.addItem(value);
        }
        this.railComModeBox.setSelectedIndex(2);
        this.railComTimingBox.setVisible(true);
        this.railComTimingBox.setToolTipText(Bundle.getMessage("LV102RailComTimingTip"));
        for (String s : this.validRailComTiming) {
            this.railComTimingBox.addItem(s);
        }
        this.railComTimingBox.setSelectedIndex(4);
        JLabel jLabel = this.currentStatus;
        synchronized (jLabel) {
            this.currentStatus.setAlignmentX(0.5f);
            this.currentStatus.setVisible(true);
            this.currentStatus.setText(" ");
            log.debug("Current Status: ");
            this.getContentPane().add(this.currentStatus);
        }
        this.pack();
        this.writeSettingsButton.addActionListener(a -> {
            this.writeLV102Settings();
            this.writeSettingsButton.setSelected(false);
        });
        this.resetButton.addActionListener(a -> {
            this.resetLV102Settings();
            this.resetButton.setSelected(false);
        });
        this.defaultButton.addActionListener(a -> {
            this.defaultLV102Settings();
            this.defaultButton.setSelected(false);
        });
        this.eLineBox.addActionListener(a -> {
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_CHANGED));
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_CHANGED));
            }
        });
        this.railComBox.addActionListener(a -> {
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_CHANGED));
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_CHANGED));
            }
        });
        this.railComModeBox.addActionListener(a -> {
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_CHANGED));
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_CHANGED));
            }
        });
        this.railComTimingBox.addActionListener(a -> {
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_CHANGED));
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_CHANGED));
            }
        });
        this.voltBox.addActionListener(a -> {
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_CHANGED));
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_CHANGED));
            }
        });
        this.setClosable(false);
        this.setResizable(false);
        this.setIconifiable(false);
        this.setMaximizable(false);
        this.setVisible(true);
    }

    void writeLV102Settings() {
        AddressedProgrammerManager pm = InstanceManager.getNullableDefault(AddressedProgrammerManager.class);
        if (pm == null) {
            this.currentStatus.setText(Bundle.getMessage("LV102StatusNoPM"));
            log.error("No Programmer Manager Available, cannot configure LV102");
            return;
        }
        AddressedProgrammer opsProg = pm.getAddressedProgrammer(false, 0);
        if (opsProg == null) {
            this.currentStatus.setText(Bundle.getMessage("LV102StatusNoPOM"));
            log.error("Failed to obtain Operations Mode Programmer, cannot configure LV102");
            return;
        }
        this.writeVoltSetting(opsProg);
        this.writeELineSetting(opsProg);
        this.writeRailComSetting(opsProg);
        this.writeRailComModeSetting(opsProg);
        this.writeRailComTimingSetting(opsProg);
        pm.releaseAddressedProgrammer(opsProg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeVoltSetting(Programmer opsProg) {
        if (!this.voltBox.getSelectedItem().equals("") && this.voltBox.getSelectedItem() != null) {
            log.debug("Selected Voltage: {}", this.voltBox.getSelectedItem());
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                new WaitHandler(this, 1000L);
                try {
                    opsProg.writeCV("7", 50, this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_WRITE_VOLT));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_WRITE_VOLT));
                try {
                    opsProg.writeCV("7", this.validVoltageValues[this.voltBox.getSelectedIndex()], this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
            }
        }
        log.debug("No Voltage Selected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeELineSetting(Programmer opsProg) {
        if (!this.eLineBox.getSelectedItem().equals("") && this.eLineBox.getSelectedItem() != null) {
            log.debug("E-Line Setting: {}", this.eLineBox.getSelectedItem());
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                new WaitHandler(this, 1000L);
                try {
                    opsProg.writeCV("7", 50, this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
                this.currentStatus.setText(Bundle.getMessage("LV102StatusWriteELine"));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage("LV102StatusWriteELine"));
                try {
                    opsProg.writeCV("7", this.validELineStatusValues[this.eLineBox.getSelectedIndex()], this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
            }
        }
        log.debug("No E-Line value Selected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRailComSetting(Programmer opsProg) {
        if (!this.railComBox.getSelectedItem().equals("") && this.railComBox.getSelectedItem() != null) {
            log.debug("RailCom Setting: {}", this.railComBox.getSelectedItem());
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                new WaitHandler(this, 1000L);
                try {
                    opsProg.writeCV("7", 50, this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
                this.currentStatus.setText(Bundle.getMessage("LV102StatusWriteRailCom"));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage("LV102StatusWriteRailCom"));
                try {
                    opsProg.writeCV("7", this.validRailComStatusValues[this.railComBox.getSelectedIndex()], this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
            }
        }
        log.debug("No RailCom value Selected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRailComModeSetting(Programmer opsProg) {
        if (!this.railComModeBox.getSelectedItem().equals("") && this.railComModeBox.getSelectedItem() != null) {
            log.debug("RailCom Setting: {}", this.railComModeBox.getSelectedItem());
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                new WaitHandler(this, 1000L);
                try {
                    opsProg.writeCV("7", 50, this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_WRITE_RAIL_COM_MODE));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_WRITE_RAIL_COM_MODE));
                try {
                    opsProg.writeCV("7", this.validRailComModeValues[this.railComModeBox.getSelectedIndex()], this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
            }
        }
        log.debug("No RailCom Mode Selected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRailComTimingSetting(Programmer opsProg) {
        if (!this.railComTimingBox.getSelectedItem().equals("") && this.railComTimingBox.getSelectedItem() != null) {
            log.debug("RailCom Timing Setting: {}", this.railComTimingBox.getSelectedItem());
            JLabel jLabel = this.currentStatus;
            synchronized (jLabel) {
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_PROG_MODE));
                new WaitHandler(this, 1000L);
                try {
                    opsProg.writeCV("7", 50, this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
                this.currentStatus.setText(Bundle.getMessage(LV_102_STATUS_WRITE_RAIL_COM_MODE));
                this.currentStatus.doLayout();
                log.debug(DEBUG_STATUS, (Object)Bundle.getMessage(LV_102_STATUS_WRITE_RAIL_COM_MODE));
                try {
                    opsProg.writeCV("7", this.validRailComTimingValues[this.railComTimingBox.getSelectedIndex()], this.progListener);
                }
                catch (ProgrammerException programmerException) {
                    // empty catch block
                }
                new WaitHandler(this, 1000L);
            }
        }
        log.debug("No RailCom Timing Mode Selected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void defaultLV102Settings() {
        this.voltBox.setSelectedIndex(10);
        this.eLineBox.setSelectedIndex(0);
        this.railComBox.setSelectedIndex(1);
        this.railComModeBox.setSelectedIndex(0);
        this.railComTimingBox.setSelectedIndex(0);
        JLabel jLabel = this.currentStatus;
        synchronized (jLabel) {
            this.currentStatus.setText(Bundle.getMessage("LV102StatusInitial"));
            log.debug("Current Status: Factory Default Settings. May Not match actual configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetLV102Settings() {
        this.voltBox.setSelectedIndex(23);
        this.eLineBox.setSelectedIndex(3);
        this.railComBox.setSelectedIndex(2);
        this.railComModeBox.setSelectedIndex(2);
        JLabel jLabel = this.currentStatus;
        synchronized (jLabel) {
            this.currentStatus.setText(Bundle.getMessage("StatusOK"));
            log.debug("Current Status: OK");
        }
    }

    private class ProgReplyListener
    implements ProgListener {
        ProgReplyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"NO_NOTIFY_NOT_NOTIFYALL"}, justification="There should only ever be one thread waiting for this method.")
        public void programmingOpReply(int value, int status) {
            log.debug("Programming Operation reply received, value is {}, status is {}", (Object)value, (Object)status);
            if (status == 4) {
                JLabel jLabel = LV102InternalFrame.this.currentStatus;
                synchronized (jLabel) {
                    LV102InternalFrame.this.currentStatus.setText(Bundle.getMessage("LV102StatusBUSY"));
                    log.debug(LV102InternalFrame.DEBUG_STATUS, (Object)Bundle.getMessage("LV102StatusBUSY"));
                    LV102InternalFrame.this.currentStatus.notify();
                }
            }
            if (status == 0) {
                if (LV102InternalFrame.this.currentStatus.getText().equals(Bundle.getMessage(LV102InternalFrame.LV_102_STATUS_PROG_MODE))) {
                    JLabel jLabel = LV102InternalFrame.this.currentStatus;
                    synchronized (jLabel) {
                        LV102InternalFrame.this.currentStatus.setText(Bundle.getMessage("LV102StatusReadyProg"));
                        log.debug(LV102InternalFrame.DEBUG_STATUS, (Object)Bundle.getMessage("LV102StatusReadyProg"));
                        LV102InternalFrame.this.currentStatus.notify();
                    }
                } else {
                    JLabel jLabel = LV102InternalFrame.this.currentStatus;
                    synchronized (jLabel) {
                        LV102InternalFrame.this.currentStatus.setText(Bundle.getMessage("LV102StatusWritten"));
                        log.debug(LV102InternalFrame.DEBUG_STATUS, (Object)Bundle.getMessage("LV102StatusWritten"));
                        LV102InternalFrame.this.currentStatus.notify();
                    }
                }
            } else {
                JLabel jLabel = LV102InternalFrame.this.currentStatus;
                synchronized (jLabel) {
                    LV102InternalFrame.this.currentStatus.setText(Bundle.getMessage("LV102StatusUnknown"));
                    log.debug(LV102InternalFrame.DEBUG_STATUS, (Object)Bundle.getMessage("LV102StatusUnknown"));
                    LV102InternalFrame.this.currentStatus.notify();
                }
            }
        }
    }
}

