/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.swing.lz100;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.swing.lz100.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LZ100InternalFrame
extends JInternalFrame
implements XNetListener {
    private boolean autoMode = false;
    private int resetMode = 0;
    private static final int IDLE = 0;
    private static final int ONSENT = 1;
    private static final int OFFSENT = 2;
    private int sendCount = 0;
    protected XNetTrafficController tc;
    boolean read = false;
    final JLabel status = new JLabel(" ");
    final JButton resetCSButton = new JButton(Bundle.getMessage("LZ100Reset"));
    final JRadioButton isAutoMode = new JRadioButton(Bundle.getMessage("Automatic"));
    final JRadioButton isManualMode = new JRadioButton(Bundle.getMessage("Manual"));
    final JToggleButton amModeGetButton = new JToggleButton(Bundle.getMessage("LZ100GetAMMode"));
    final JToggleButton amModeSetButton = new JToggleButton(Bundle.getMessage("LZ100SetAMMode"));
    private static final Logger log = LoggerFactory.getLogger(LZ100InternalFrame.class);

    public LZ100InternalFrame(XNetSystemConnectionMemo memo) {
        this.tc = memo.getXNetTrafficController();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setTitle(Bundle.getMessage("CommandConfigTitle"));
        JPanel pane4 = new JPanel();
        pane4.add(new JLabel(Bundle.getMessage("LZ100StartMode")));
        this.isAutoMode.setVisible(true);
        this.isAutoMode.setToolTipText(Bundle.getMessage("LZ100AutoModeToolTip"));
        pane4.add(this.isAutoMode);
        this.isManualMode.setVisible(true);
        this.isManualMode.setToolTipText(Bundle.getMessage("LZ100ManualModeToolTip"));
        pane4.add(this.isManualMode);
        this.amModeGetButton.setToolTipText(Bundle.getMessage("LZ100GetAMModeToolTip"));
        pane4.add(this.amModeGetButton);
        this.amModeSetButton.setToolTipText(Bundle.getMessage("LZ100SetAMModeToolTip"));
        pane4.add(this.amModeSetButton);
        this.getContentPane().add(pane4);
        JPanel pane3 = new JPanel();
        pane3.add(new JLabel(Bundle.getMessage("LZ100OptionLabel")));
        this.resetCSButton.setToolTipText(Bundle.getMessage("LZ100ResetToolTip"));
        pane3.add(this.resetCSButton);
        this.getContentPane().add(pane3);
        this.status.setAlignmentX(0.5f);
        this.status.setVisible(true);
        this.getContentPane().add(this.status);
        this.pack();
        this.resetCSButton.addActionListener(a -> {
            if (0 == JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("LZ100ConfirmResetDialog"), Bundle.getMessage("QuestionTitle"), 2, 2)) {
                this.resetLZ100CS();
            }
        });
        this.amModeGetButton.addActionListener(a -> this.amModeGet());
        this.amModeSetButton.addActionListener(a -> this.amModeSave());
        this.isAutoMode.addActionListener(a -> this.autoModeAction());
        this.isManualMode.addActionListener(a -> this.manualModeAction());
        this.setClosable(false);
        this.setResizable(false);
        this.setIconifiable(false);
        this.setMaximizable(false);
        this.setVisible(true);
        if (this.tc != null) {
            this.tc.addXNetListener(-1, this);
        } else {
            log.warn("No XpressNet connection, so panel won't function");
        }
    }

    @Override
    public synchronized void message(XNetReply l) {
        if (l.isOkMessage()) {
            if (this.status.getText().equals(Bundle.getMessage("LZ100StatusSetMode"))) {
                this.status.setText(Bundle.getMessage("StatusOK"));
            }
            if (this.resetMode == 2) {
                XNetMessage msgon = XNetMessage.getFunctionGroup1OpsMsg(0, false, false, false, false, true);
                --this.sendCount;
                this.resetMode = 1;
                this.tc.sendXNetMessage(msgon, this);
            } else if (this.resetMode == 1) {
                XNetMessage msgoff = XNetMessage.getFunctionGroup1OpsMsg(0, false, false, false, false, false);
                if (this.sendCount >= 0) {
                    this.resetMode = 2;
                } else {
                    this.resetMode = 0;
                    this.resetCSButton.setEnabled(true);
                    this.status.setText(Bundle.getMessage("LZ100ResetFinished"));
                }
                this.tc.sendXNetMessage(msgoff, this);
            }
        } else if (l.getElement(0) == 98 && l.getElement(1) == 34) {
            int statusByte = l.getElement(2);
            if ((statusByte & 4) == 4) {
                this.isAutoMode.setSelected(true);
                this.isManualMode.setSelected(false);
                this.autoMode = true;
                this.status.setText(Bundle.getMessage("StatusOK"));
            } else {
                this.isAutoMode.setSelected(false);
                this.isManualMode.setSelected(true);
                this.autoMode = false;
                this.status.setText(Bundle.getMessage("StatusOK"));
            }
        }
    }

    @Override
    public synchronized void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message {}", (Object)msg.toString());
    }

    synchronized void resetLZ100CS() {
        this.resetCSButton.setEnabled(false);
        this.status.setText(Bundle.getMessage("LZ100StatusReset"));
        XNetMessage msgon = XNetMessage.getFunctionGroup1OpsMsg(0, false, false, false, true, false);
        this.resetMode = 1;
        this.sendCount = 25;
        this.tc.sendXNetMessage(msgon, this);
    }

    synchronized void amModeGet() {
        XNetMessage msg = XNetMessage.getCSStatusRequestMessage();
        this.tc.sendXNetMessage(msg, this);
        this.amModeGetButton.setSelected(false);
        this.status.setText(Bundle.getMessage("LZ100StatusRetrieveMode"));
    }

    synchronized void amModeSave() {
        if (this.autoMode) {
            log.debug("Auto Mode True");
        } else {
            log.debug("Auto Mode False");
        }
        XNetMessage msg = XNetMessage.getCSAutoStartMessage(this.autoMode);
        this.tc.sendXNetMessage(msg, this);
        this.amModeSetButton.setSelected(false);
        this.status.setText(Bundle.getMessage("LZ100StatusSetMode"));
    }

    synchronized void autoModeAction() {
        log.debug("Auto Mode Action Called");
        this.isAutoMode.setSelected(true);
        this.isManualMode.setSelected(false);
        this.autoMode = true;
    }

    synchronized void manualModeAction() {
        log.debug("Manual Mode Action Called");
        this.isAutoMode.setSelected(false);
        this.isManualMode.setSelected(true);
        this.autoMode = false;
    }
}

