/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.swing.mon;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.Message;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.swing.mon.Bundle;
import jmri.util.swing.JmriNamedPaneAction;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetMonPane
extends AbstractMonPane
implements XNetListener {
    protected XNetTrafficController tc = null;
    protected XNetSystemConnectionMemo memo = null;
    private List<XPressNetMessageFormatter> formatterList;
    private static final Logger log = LoggerFactory.getLogger(XNetMonPane.class);

    @Override
    public String getTitle() {
        return Bundle.getMessage("MenuItemXNetCommandMonitor");
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof XNetSystemConnectionMemo) {
            this.memo = (XNetSystemConnectionMemo)context;
            this.tc = this.memo.getXNetTrafficController();
            this.tc.addXNetListener(-1, this);
            try {
                this.formatterList = new ArrayList<XPressNetMessageFormatter>();
                Reflections reflections = new Reflections("jmri.jmrix.lenz.messageformatters", new Scanner[0]);
                Set f = reflections.getSubTypesOf(XPressNetMessageFormatter.class);
                for (Class c : f) {
                    log.debug("Found formatter: {}", (Object)f.getClass().getName());
                    Constructor ctor = c.getConstructor(new Class[0]);
                    this.formatterList.add((XPressNetMessageFormatter)ctor.newInstance(new Object[0]));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Error instantiating formatter", (Throwable)e);
            }
        }
    }

    @Override
    protected void init() {
    }

    @Override
    public void dispose() {
        this.tc.removeXNetListener(-1, this);
        super.dispose();
    }

    @Override
    public void logMessage(String messagePrefix, String rawPrefix, Message message) {
        StringBuilder raw = new StringBuilder(rawPrefix);
        if (this.rawCheckBox.isSelected()) {
            raw.append(message.toString());
        }
        String text = this.formatterList.stream().filter(f -> f.handlesMessage(message)).findFirst().map(f -> f.formatMessage(message)).orElse(message.toString());
        this.nextLine(messagePrefix + " " + text + "\n", raw.toString());
    }

    @Override
    public synchronized void message(XNetReply l) {
        this.logMessage("", "packet:", l);
    }

    @Override
    public synchronized void message(XNetMessage l) {
        this.logMessage("", "packet:", l);
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message {}", (Object)msg.toString());
    }

    public static class Default
    extends JmriNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemXNetCommandMonitor"), XNetMonPane.class.getName());
            this.setContext(InstanceManager.getDefault(XNetSystemConnectionMemo.class));
        }
    }
}

