/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.swing.systeminfo;

import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.swing.systeminfo.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoFrame
extends JmriJFrame
implements XNetListener {
    protected XNetTrafficController tc;
    boolean read = false;
    final JLabel CSType = new JLabel("                ");
    final JLabel CSSoftwareVersion = new JLabel("");
    final JLabel CSStatus = new JLabel(Bundle.getMessage("BeanStateUnknown"));
    final JLabel LIType = new JLabel("       ");
    final JLabel LIHardwareVersion = new JLabel("");
    final JLabel LISoftwareVersion = new JLabel("");
    final JToggleButton getSystemInfoButton = new JToggleButton(Bundle.getMessage("GetSystemInfoButtonLabel"));
    final JButton closeButton = new JButton(Bundle.getMessage("ButtonClose"));
    private static final Logger log = LoggerFactory.getLogger(SystemInfoFrame.class);

    public SystemInfoFrame(XNetSystemConnectionMemo memo) {
        super(Bundle.getMessage("MenuItemXNetSystemInformation"));
        this.tc = memo.getXNetTrafficController();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel infoPane = new JPanel();
        infoPane.setBorder(BorderFactory.createEtchedBorder());
        infoPane.setLayout(new GridLayout(6, 2));
        infoPane.add(new JLabel(Bundle.getMessage("CommandStationLabel")));
        infoPane.add(this.CSType);
        infoPane.add(new JLabel(Bundle.getMessage("SoftwareVersionLabel")));
        infoPane.add(this.CSSoftwareVersion);
        infoPane.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("StatusCol"))));
        infoPane.add(this.CSStatus);
        infoPane.add(new JLabel(Bundle.getMessage("InterfaceLabel")));
        infoPane.add(this.LIType);
        infoPane.add(new JLabel(Bundle.getMessage("HardwareVersionLabel")));
        infoPane.add(this.LIHardwareVersion);
        infoPane.add(new JLabel(Bundle.getMessage("SoftwareVersionLabel")));
        infoPane.add(this.LISoftwareVersion);
        this.getContentPane().add(infoPane);
        this.getContentPane().add(Box.createVerticalGlue());
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.getSystemInfoButton);
        buttonPane.add(this.closeButton);
        this.getContentPane().add(buttonPane);
        this.addHelpMenu("package.jmri.jmrix.lenz.systeminfo.SystemInfoFrame", true);
        this.pack();
        this.setCSVersionDisplay();
        this.getSystemInfoButton.addActionListener(a -> this.getSystemInfo());
        this.closeButton.addActionListener(a -> {
            this.setVisible(false);
            this.dispose();
        });
        if (this.tc != null) {
            this.tc.addXNetListener(-1, this);
        } else {
            log.warn("No XpressNet connection, panel won't function");
        }
    }

    void getSystemInfo() {
        XNetMessage msg = XNetMessage.getCSVersionRequestMessage();
        this.tc.sendXNetMessage(msg, this);
        XNetMessage msg2 = XNetMessage.getLIVersionRequestMessage();
        this.tc.sendXNetMessage(msg2, this);
        XNetMessage msg3 = XNetMessage.getCSStatusRequestMessage();
        this.tc.sendXNetMessage(msg3, this);
    }

    @Override
    public void message(XNetReply l) {
        if (l.getElement(0) == 2) {
            this.LIHardwareVersion.setText("" + l.getElementBCD(1).floatValue() / 10.0f);
            this.LISoftwareVersion.setText("" + l.getElementBCD(2));
        } else if (l.getElement(0) == 99) {
            if (l.getElement(1) == 33) {
                this.tc.getCommandStation().setCommandStationSoftwareVersion(l);
                this.tc.getCommandStation().setCommandStationType(l);
                this.setCSVersionDisplay();
            }
        } else if (l.getElement(0) == 98 && l.getElement(1) == 34) {
            int statusByte = l.getElement(2);
            if ((statusByte & 1) == 1) {
                this.CSStatus.setText(Bundle.getMessage("XNetCSStatusEmergencyOff"));
            } else if ((statusByte & 2) == 2) {
                this.CSStatus.setText(Bundle.getMessage("XNetCSStatusEmergencyStop"));
            } else if ((statusByte & 8) == 8) {
                this.CSStatus.setText(Bundle.getMessage("XNetCSStatusServiceMode"));
            } else if ((statusByte & 0x40) == 64) {
                if ((statusByte & 4) == 4) {
                    this.CSStatus.setText(Bundle.getMessage("XNetCSStatusPoweringUp") + ": " + Bundle.getMessage("XNetCSStatusPowerModeAuto"));
                } else {
                    this.CSStatus.setText(Bundle.getMessage("XNetCSStatusPoweringUp") + ": " + Bundle.getMessage("XNetCSStatusPowerModeManual"));
                }
            } else if ((statusByte & 0x80) == 128) {
                this.CSStatus.setText(Bundle.getMessage("XNetCSStatusRamCheck"));
            } else {
                this.CSStatus.setText(Bundle.getMessage("XNetCSStatusRamNormal"));
            }
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message{}", (Object)msg.toString());
        }
    }

    private void setCSVersionDisplay() {
        this.CSSoftwareVersion.setText("" + this.tc.getCommandStation().getCommandStationSoftwareVersion());
        int cs_type = this.tc.getCommandStation().getCommandStationType();
        if (cs_type == 0) {
            this.CSType.setText(Bundle.getMessage("CSTypeLZ100"));
        } else if (cs_type == 1) {
            this.CSType.setText(Bundle.getMessage("CSTypeLH200"));
        } else if (cs_type == 2) {
            this.CSType.setText(Bundle.getMessage("CSTypeCompact"));
        } else if (cs_type == 16) {
            this.CSType.setText(Bundle.getMessage("CSTypeMultiMaus"));
        } else if (cs_type == 18) {
            this.CSType.setText(Bundle.getMessage("CSTypeZ21"));
        } else if (cs_type == 4) {
            this.CSType.setText(Bundle.getMessage("CSTypeLokMaus"));
        } else if (cs_type == 7) {
            this.CSType.setText(Bundle.getMessage("CSTypeLDH35"));
        } else {
            this.CSType.setText(Bundle.getMessage("StateUnknown"));
        }
    }
}

