/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.xntcp;

import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.AbstractNetworkConnectionConfig;
import jmri.jmrix.JmrixConfigPane;
import jmri.jmrix.NetworkPortAdapter;
import jmri.jmrix.lenz.xntcp.Bundle;
import jmri.jmrix.lenz.xntcp.XnTcpAdapter;

public class ConnectionConfig
extends AbstractNetworkConnectionConfig {
    private static final String XN_TCP_INTERFACE = "XnTcpInterface";
    private static final String MANUAL = "Manual";
    String manufacturerName = "Lenz";

    public ConnectionConfig(NetworkPortAdapter p) {
        super(p);
        String t;
        String h = this.adapter.getHostName();
        if (h != null && !h.equals(JmrixConfigPane.NONE)) {
            this.hostNameField = new JTextField(h);
        }
        if (!(t = "" + this.adapter.getPort()).equals("0")) {
            this.portField = new JTextField(t);
        }
    }

    public ConnectionConfig() {
    }

    @Override
    public String name() {
        return Bundle.getMessage("XnTcpName");
    }

    @Override
    protected void setInstance() {
        if (this.adapter == null) {
            this.adapter = new XnTcpAdapter();
        }
    }

    @Override
    public String getInfo() {
        Object x = this.adapter.getOptionState(XN_TCP_INTERFACE);
        if (x == null) {
            return JmrixConfigPane.NONE;
        }
        x = ((String)x).equals(Bundle.getMessage(MANUAL)) ? "" : (String)x + ":";
        String t = this.adapter.getHostName();
        int p = this.adapter.getPort();
        if (t != null && !t.equals("")) {
            if (p != 0) {
                return (String)x + t + ":" + p;
            }
            return (String)x + t;
        }
        return JmrixConfigPane.NONE;
    }

    @Override
    public void loadDetails(JPanel d) {
        super.loadDetails(d);
        if (((AbstractConnectionConfig.Option)this.options.get(XN_TCP_INTERFACE)).getComponent() instanceof JComboBox) {
            ((JComboBox)((AbstractConnectionConfig.Option)this.options.get(XN_TCP_INTERFACE)).getComponent()).addActionListener(e -> this.enableInput());
        }
    }

    @Override
    protected void showAdvancedItems() {
        super.showAdvancedItems();
        this.enableInput();
        this._details.repaint();
    }

    private void enableInput() {
        String choice = ((AbstractConnectionConfig.Option)this.options.get(XN_TCP_INTERFACE)).getItem();
        boolean manualInput = false;
        if (choice != null) {
            manualInput = choice.equals(Bundle.getMessage(MANUAL)) || choice.equals(MANUAL);
        }
        this.hostNameField.setEnabled(manualInput);
        this.portField.setEnabled(manualInput);
        this.adapter.configureOption1(choice);
        this.adapter.setHostName(this.hostNameField.getText());
        this.adapter.setPort(this.portField.getText());
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerName;
    }

    @Override
    public void setManufacturer(String manu) {
        this.manufacturerName = manu;
    }

    @Override
    public boolean isHostNameAdvanced() {
        return true;
    }
}

