/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.xntcp;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetPacketizer;
import jmri.jmrix.lenz.xntcp.XnTcpAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XnTcpXNetPacketizer
extends XNetPacketizer {
    private static final Logger log = LoggerFactory.getLogger(XnTcpXNetPacketizer.class);

    public XnTcpXNetPacketizer(LenzCommandStation pCommandStation) {
        super(pCommandStation);
        log.debug("Loading XnTcp Extension to XNetPacketizer");
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        int i = 0;
        try {
            while (i < msg.maxSize()) {
                int char1 = istream.read();
                if (char1 < 0) {
                    ((XnTcpAdapter)this.controller).xnTcpError();
                    throw new EOFException("Lost communication with XnTcp interface");
                }
                msg.setElement(i++, (byte)char1 & 0xFF);
                log.debug("XnTcpNetPacketizer: received {}", (Object)Integer.toHexString(char1 & 0xFF));
                if (!this.endOfMessage(msg)) continue;
            }
            ((XnTcpAdapter)this.controller).xnTcpSetPendingPackets(-1);
            log.debug("XnTcpNetPacketizer: received end of packet");
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException ex) {
            ((XnTcpAdapter)this.controller).xnTcpError();
            throw ex;
        }
    }
}

