/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import jmri.JmriException;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBoardProgPanel
extends LnPanel
implements LocoNetListener {
    JPanel contents = new JPanel();
    public JToggleButton readAllButton = null;
    public JToggleButton writeAllButton = null;
    public JTextField addrField = new JTextField(4);
    JLabel status = new JLabel();
    public boolean read = false;
    public int state = 0;
    boolean awaitingReply = false;
    int replyTryCount = 0;
    public Timer responseTimer = null;
    public Timer pacingTimer = null;
    public boolean onlyOneOperation = false;
    int address = 0;
    int typeWord;
    boolean readOnInit;
    protected boolean[] opsw = new boolean[65];
    private static final int HALF_A_SECOND = 500;
    private static final int FIFTIETH_OF_A_SECOND = 20;
    private String boardTypeName;
    private ActionListener responseTimerListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AbstractBoardProgPanel.this.responseTimer.isRunning() && AbstractBoardProgPanel.this.awaitingReply) {
                if (AbstractBoardProgPanel.this.replyTryCount < 2) {
                    ++AbstractBoardProgPanel.this.replyTryCount;
                    log.debug("retrying({}) access to OpSw{}", (Object)AbstractBoardProgPanel.this.replyTryCount, (Object)AbstractBoardProgPanel.this.state);
                    AbstractBoardProgPanel.this.responseTimer.stop();
                    AbstractBoardProgPanel.this.delayedNextRequest();
                    return;
                }
                log.warn("Reached OpSw access retry limit of {} when accessing OpSw{}", (Object)2, (Object)AbstractBoardProgPanel.this.state);
                AbstractBoardProgPanel.this.awaitingReply = false;
                AbstractBoardProgPanel.this.responseTimer.stop();
                AbstractBoardProgPanel.this.state = 0;
                AbstractBoardProgPanel.this.replyTryCount = 0;
                AbstractBoardProgPanel.this.doTheNextThing();
            }
        }
    };
    private ActionListener pacingTimerListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractBoardProgPanel.this.pacingTimer.isRunning()) {
                log.warn("Unexpected pacing timer event while OpSw access timer is running.");
            } else {
                AbstractBoardProgPanel.this.pacingTimer.stop();
                AbstractBoardProgPanel.this.delayedNextRequest();
            }
        }
    };
    private final int MAX_OPSW_ACCESS_RETRIES = 2;
    private static final Logger log = LoggerFactory.getLogger(AbstractBoardProgPanel.class);

    protected AbstractBoardProgPanel(String boardTypeName) {
        this(1, false, boardTypeName);
    }

    protected AbstractBoardProgPanel(boolean readOnInit, String boardTypeName) {
        this(1, readOnInit, boardTypeName);
    }

    protected AbstractBoardProgPanel(int boardNum, boolean readOnInit, String boardTypeName) {
        this.boardTypeName = boardTypeName;
        this.contents.setLayout(new BoxLayout(this.contents, 1));
        this.addrField.setText(Integer.toString(boardNum));
        this.readOnInit = readOnInit;
    }

    protected AbstractBoardProgPanel(int boardNum, String boardTypeName) {
        this(boardNum, false, boardTypeName);
    }

    protected void panelToScroll() {
        JScrollPane scroll = new JScrollPane(this.contents);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(30);
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.setVisible(true);
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        if (memo.getLnTrafficController() != null) {
            memo.getLnTrafficController().addLocoNetListener(-1, this);
            if (this.readOnInit) {
                this.readAllButton.setSelected(true);
                this.readAllButton.updateUI();
                this.readAll();
            }
        } else {
            log.error("No LocoNet connection available, this tool cannot function");
        }
    }

    @Override
    public void initComponents() {
        this.initializeResponseTimer();
        this.initializePacingTimer();
    }

    public void setBoardIdValue(Integer boardId) {
        if (boardId < 1) {
            return;
        }
        if (boardId > 256) {
            return;
        }
        this.addrField.setText(Integer.toString(boardId));
        this.address = boardId - 1;
    }

    public Integer getBoardIdValue() {
        return Integer.parseInt(this.addrField.getText());
    }

    protected JPanel provideAddressing() {
        return this.provideAddressing(this.boardTypeName);
    }

    protected JPanel provideAddressing(String boardTypeName) {
        JPanel pane0 = new JPanel();
        pane0.setLayout(new FlowLayout());
        pane0.add(new JLabel(Bundle.getMessage("LABEL_UNIT_ADDRESS") + " "));
        pane0.add(this.addrField);
        this.readAllButton = new JToggleButton(Bundle.getMessage("AbstractBoardProgPanel_ReadFrom", boardTypeName));
        this.writeAllButton = new JToggleButton(Bundle.getMessage("AbstractBoardProgPanel_WriteTo", boardTypeName));
        Dimension d = this.writeAllButton.getPreferredSize();
        int w = d.width;
        d = this.readAllButton.getPreferredSize();
        if (d.width > w) {
            w = d.width;
        }
        this.writeAllButton.setPreferredSize(new Dimension((int)((double)w * 1.1), d.height));
        this.readAllButton.setPreferredSize(new Dimension((int)((double)w * 1.1), d.height));
        pane0.add(this.readAllButton);
        pane0.add(this.writeAllButton);
        this.readAllButton.addActionListener(a -> {
            if (this.readAllButton.isSelected()) {
                this.readAll();
            }
        });
        this.writeAllButton.addActionListener(a -> {
            if (this.writeAllButton.isSelected()) {
                this.writeAll();
            }
        });
        return pane0;
    }

    protected JComponent provideStatusLine() {
        this.status.setFont(this.status.getFont().deriveFont(0.9f * (float)this.addrField.getFont().getSize()));
        this.status.setForeground(Color.gray);
        return this.status;
    }

    protected void setStatus(String msg) {
        this.status.setText(msg);
    }

    protected void appendLine(JComponent c) {
        c.setAlignmentX(0.0f);
        this.contents.add(c);
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="I18N of log message")
    public void readAll() {
        try {
            this.setAddress(256);
        }
        catch (Exception e) {
            log.debug("{}", (Object)Bundle.getMessage("ERROR_READALL_INVALID_ADDRESS"));
            this.readAllButton.setSelected(false);
            this.writeAllButton.setSelected(false);
            this.status.setText(" ");
            return;
        }
        if (this.responseTimer == null) {
            this.initializeResponseTimer();
        }
        if (this.pacingTimer == null) {
            this.initializePacingTimer();
        }
        this.read = true;
        this.state = 1;
        this.nextRequest();
    }

    protected void setTypeWord(int type) {
        this.typeWord = type;
    }

    private final void delayedNextRequest() {
        this.pacingTimer.stop();
        if (this.read) {
            this.status.setText(Bundle.getMessage("STATUS_READING_OPSW") + " " + this.state);
            LocoNetMessage l = new LocoNetMessage(6);
            l.setOpCode(208);
            int element = 98;
            if ((this.address & 0x80) != 0) {
                element |= 1;
            }
            l.setElement(1, element);
            l.setElement(2, this.address & 0x7F);
            l.setElement(3, this.typeWord);
            int loc = (this.state - 1) / 8;
            int bit = this.state - 1 - loc * 8;
            l.setElement(4, loc * 16 + bit * 2);
            this.memo.getLnTrafficController().sendLocoNetMessage(l);
            this.awaitingReply = true;
            this.responseTimer.stop();
            this.responseTimer.restart();
        } else {
            this.status.setText(Bundle.getMessage("STATUS_WRITING_OPSW") + " " + this.state);
            LocoNetMessage l = new LocoNetMessage(6);
            l.setOpCode(208);
            int element = 114;
            if ((this.address & 0x80) != 0) {
                element |= 1;
            }
            l.setElement(1, element);
            l.setElement(2, this.address & 0x7F);
            l.setElement(3, this.typeWord);
            int loc = (this.state - 1) / 8;
            int bit = this.state - 1 - loc * 8;
            l.setElement(4, loc * 16 + bit * 2 + (this.opsw[this.state] ? 1 : 0));
            this.memo.getLnTrafficController().sendLocoNetMessage(l);
            this.awaitingReply = true;
            this.responseTimer.stop();
            this.responseTimer.restart();
        }
    }

    private final void nextRequest() {
        this.pacingTimer.stop();
        this.pacingTimer.restart();
        this.replyTryCount = 0;
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="I18N of log message")
    void setAddress(int maxValid) throws JmriException {
        try {
            this.address = Integer.parseInt(this.addrField.getText()) - 1;
        }
        catch (NumberFormatException e) {
            this.readAllButton.setSelected(false);
            this.writeAllButton.setSelected(false);
            this.status.setText(Bundle.getMessage("STATUS_INPUT_BAD"));
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("STATUS_INVALID_ADDRESS"), Bundle.getMessage("STATUS_TYPE_ERROR"), 0);
            log.error("{}", (Object)Bundle.getMessage("ERROR_PARSING_ADDRESS"), (Object)e);
            throw e;
        }
        if (this.address > maxValid - 1 || this.address < 0) {
            this.readAllButton.setSelected(false);
            this.writeAllButton.setSelected(false);
            this.status.setText(Bundle.getMessage("STATUS_INPUT_BAD"));
            String message = Bundle.getMessage("AbstractBoardProgPanel_ErrorAddressRange", 1, maxValid);
            JmriJOptionPane.showMessageDialog(this, message, Bundle.getMessage("ErrorTitle"), 0);
            log.error("Invalid board ID number: {}", (Object)Integer.toString(this.address));
            throw new JmriException(Bundle.getMessage("ERROR_INVALID_ADDRESS") + " " + this.address);
        }
    }

    protected abstract void copyToOpsw();

    protected abstract void updateDisplay();

    protected abstract int nextState(int var1);

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="I18N of log message")
    public void writeAll() {
        try {
            this.setAddress(256);
        }
        catch (Exception e) {
            log.debug("{}", (Object)Bundle.getMessage("ERROR_WRITEALL_ABORTED"), (Object)e);
            this.readAllButton.setSelected(false);
            this.writeAllButton.setSelected(false);
            this.status.setText(" ");
            return;
        }
        if (this.responseTimer == null) {
            this.initializeResponseTimer();
        }
        if (this.pacingTimer == null) {
            this.initializePacingTimer();
        }
        this.copyToOpsw();
        this.read = false;
        this.state = 1;
        this.onlyOneOperation = false;
        this.nextRequest();
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="I18N of log message")
    public void writeOne(int opswIndex) {
        try {
            this.setAddress(256);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)Bundle.getMessage("ERROR_WRITEONE_ABORTED"), (Object)e);
            }
            this.readAllButton.setSelected(false);
            this.writeAllButton.setSelected(false);
            this.status.setText(" ");
            return;
        }
        this.copyToOpsw();
        this.read = false;
        this.state = opswIndex;
        this.onlyOneOperation = true;
        this.nextRequest();
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="I18N of log message")
    public void message(LocoNetMessage m) {
        if (log.isDebugEnabled()) {
            log.debug("{} {}", (Object)Bundle.getMessage("DEBUG_PARSING_LOCONET_MESSAGE"), (Object)m);
        }
        if (this.state == 0) {
            return;
        }
        if (m.getOpCode() != 180 || m.getElement(1) != 0 && m.getElement(1) != 80) {
            return;
        }
        if (this.awaitingReply && this.responseTimer != null && this.responseTimer.isRunning()) {
            this.responseTimer.stop();
        }
        boolean value = false;
        if ((m.getElement(2) & 0x20) != 0) {
            value = true;
        }
        if (m.getElement(2) != 127) {
            this.opsw[this.state] = value;
        }
        if (this.read) {
            this.updateDisplay();
        }
        this.doTheNextThing();
    }

    public void doTheNextThing() {
        int origState = this.state;
        if (origState != 0) {
            this.state = this.nextState(origState);
        }
        if (origState == 0 || this.state == 0) {
            this.readAllButton.setSelected(false);
            this.writeAllButton.setSelected(false);
            if (origState != 0) {
                this.status.setText(Bundle.getMessage("AbstractBoardProgPanel_Done_Message"));
            } else {
                this.status.setText(Bundle.getMessage("ERROR_ABORTED_DUE_TO_TIMEOUT"));
            }
        } else {
            this.nextRequest();
        }
    }

    private void initializeResponseTimer() {
        if (this.responseTimer == null) {
            this.responseTimer = new Timer(500, this.responseTimerListener);
            this.responseTimer.setRepeats(false);
            this.responseTimer.stop();
            this.responseTimer.setInitialDelay(500);
            this.responseTimer.setDelay(500);
        }
    }

    private void initializePacingTimer() {
        if (this.pacingTimer == null) {
            this.pacingTimer = new Timer(20, this.pacingTimerListener);
            this.pacingTimer.setRepeats(false);
            this.pacingTimer.stop();
            this.pacingTimer.setInitialDelay(20);
            this.pacingTimer.setDelay(20);
        }
    }

    @Override
    public void dispose() {
        if (this.memo.getLnTrafficController() != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
        super.dispose();
        if (this.responseTimer != null) {
            this.responseTimer.stop();
        }
        if (this.pacingTimer != null) {
            this.pacingTimer.stop();
        }
    }
}

