/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.LocoNetThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ib1Throttle
extends LocoNetThrottle {
    private static final Logger log = LoggerFactory.getLogger(Ib1Throttle.class);

    public Ib1Throttle(LocoNetSystemConnectionMemo memo, LocoNetSlot slot) {
        super(memo, slot);
        log.debug("Ib1Throttle created");
    }

    @Override
    protected float floatSpeed(int lSpeed) {
        log.debug("IB1 floatSpeed {}", (Object)lSpeed);
        if (lSpeed == 0) {
            return 0.0f;
        }
        if (lSpeed == 1) {
            return -1.0f;
        }
        switch (this.getSpeedStepMode()) {
            case NMRA_DCC_28: 
            case MOTOROLA_28: {
                int cycle = (--lSpeed - 1) / 9;
                int ispeed = cycle * 2 + 1;
                if (lSpeed - cycle * 9 > 5) {
                    ++ispeed;
                }
                return (float)ispeed / 28.0f;
            }
            case NMRA_DCC_14: {
                int cycle = lSpeed / 19;
                int ispeed = cycle * 2 + 1;
                if (lSpeed - cycle * 19 > 9) {
                    ++ispeed;
                }
                return (float)ispeed / 14.0f;
            }
            case NMRA_DCC_128: {
                return (float)(lSpeed - 1) / 126.0f;
            }
        }
        log.warn("Unhandled speed step: {}", (Object)this.getSpeedStepMode());
        return 0.0f;
    }

    @Override
    protected int intSpeed(float speed) {
        log.debug("IB1 intSpeed {}", (Object)Float.valueOf(speed));
        int lSpeed = AbstractThrottle.intSpeed(speed, 127);
        switch (this.getSpeedStepMode()) {
            case NMRA_DCC_14: {
                if (lSpeed <= 2) break;
                --lSpeed;
                break;
            }
            case NMRA_DCC_28: 
            case MOTOROLA_28: 
            case NMRA_DCC_128: {
                break;
            }
            default: {
                log.warn("Unhandled speed step: {}", (Object)this.getSpeedStepMode());
            }
        }
        return lSpeed;
    }

    @Override
    protected void sendFunctionGroup3() {
        log.debug("IB1 sendFunctionGroup3");
        int new_IB1_F9_F11 = (this.getFunction(11) ? 64 : 0) | (this.getFunction(10) ? 32 : 0) | (this.getFunction(9) ? 16 : 0);
        LocoNetMessage msg1 = new LocoNetMessage(6);
        msg1.setOpCode(212);
        msg1.setElement(1, 32);
        msg1.setElement(2, this.slot.getSlot());
        msg1.setElement(3, 7);
        msg1.setElement(4, new_IB1_F9_F11);
        this.network.sendLocoNetMessage(msg1);
        int new_IB2_F20_F28 = (this.getFunction(12) ? 16 : 0) | (this.getFunction(20) ? 32 : 0) | (this.getFunction(28) ? 64 : 0);
        LocoNetMessage msg2 = new LocoNetMessage(6);
        msg2.setOpCode(212);
        msg2.setElement(1, 32);
        msg2.setElement(2, this.slot.getSlot());
        msg2.setElement(3, 5);
        msg2.setElement(4, new_IB2_F20_F28);
        this.network.sendLocoNetMessage(msg2);
    }

    @Override
    protected void sendFunctionGroup4() {
        log.debug("IB1 sendFunctionGroup4");
        int new_IB2_F13_F19 = (this.getFunction(19) ? 64 : 0) | (this.getFunction(18) ? 32 : 0) | (this.getFunction(17) ? 16 : 0) | (this.getFunction(16) ? 8 : 0) | (this.getFunction(15) ? 4 : 0) | (this.getFunction(14) ? 2 : 0) | (this.getFunction(13) ? 1 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(212);
        msg.setElement(1, 32);
        msg.setElement(2, this.slot.getSlot());
        msg.setElement(3, 8);
        msg.setElement(4, new_IB2_F13_F19);
        this.network.sendLocoNetMessage(msg);
        int new_IB2_F20_F28 = (this.getFunction(12) ? 16 : 0) | (this.getFunction(20) ? 32 : 0) | (this.getFunction(28) ? 64 : 0);
        LocoNetMessage msg2 = new LocoNetMessage(6);
        msg2.setOpCode(212);
        msg2.setElement(1, 32);
        msg2.setElement(2, this.slot.getSlot());
        msg2.setElement(3, 5);
        msg2.setElement(4, new_IB2_F20_F28);
        this.network.sendLocoNetMessage(msg2);
    }

    @Override
    protected void sendFunctionGroup5() {
        log.debug("IB1 sendFunctionGroup5");
        int new_IB2_F21_F27 = (this.getFunction(27) ? 64 : 0) | (this.getFunction(26) ? 32 : 0) | (this.getFunction(25) ? 16 : 0) | (this.getFunction(24) ? 8 : 0) | (this.getFunction(23) ? 4 : 0) | (this.getFunction(22) ? 2 : 0) | (this.getFunction(21) ? 1 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(212);
        msg.setElement(1, 32);
        msg.setElement(2, this.slot.getSlot());
        msg.setElement(3, 9);
        msg.setElement(4, new_IB2_F21_F27);
        this.network.sendLocoNetMessage(msg);
        int new_IB2_F20_F28 = (this.getFunction(12) ? 16 : 0) | (this.getFunction(20) ? 32 : 0) | (this.getFunction(28) ? 64 : 0);
        LocoNetMessage msg2 = new LocoNetMessage(6);
        msg2.setOpCode(212);
        msg2.setElement(1, 32);
        msg2.setElement(2, this.slot.getSlot());
        msg2.setElement(3, 5);
        msg2.setElement(4, new_IB2_F20_F28);
        this.network.sendLocoNetMessage(msg2);
    }
}

